5.1 Blocks

# Blocks

A structure you'll see a lot in Sonic Pi is the block. Blocks allow us
to do useful things with large chunks of code. For example, with synth
and sample parameters we were able to change something that happened on
a single line. However, sometimes we want to do something meaningful to
a number of lines of code. For example, we may wish to loop it, to add
reverb to it, to only run it 1 time out of 5, etc. Consider the
following code:

```
play 50
sleep 0.5
sample :elec_plip
sleep 0.5
play 62
```

To do something with a chunk of code, we need to tell Sonic Pi where
the code block *starts* and where it *ends*. We use `do` for start and
`end` for end. For example:

```
do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

However, this isn't yet complete and won't work (try it and you'll get
an error) as we haven't told Sonic Pi what we want to do with this
*do/end block*. We tell Sonic Pi this by writing some special code
before the `do`. We'll see a number of these special pieces of code
later on in this tutorial. For now, it's important to know that wrapping
your code within `do` and `end` tells Sonic Pi you wish to do something
special with that chunk of code.
