1.1 Live Coding

# Live Coding

One of the most exciting aspects of Sonic Pi is that it enables you to
write and *modify code live* to make music, just like you might perform
live with a guitar. This means that given some practice you can take
Sonic Pi on stage and gig with it.

## Free your mind

Before we get into the real details of how Sonic Pi works in the rest of
this tutorial, I'd like to give you an experience of what it's like to
live code. Don't worry if you don't understand much (or any) of
this. Just try to hold onto your seats and enjoy...

## A live loop

Let's get started, copy the following code into an empty buffer:

```
live_loop :flibble do
  sample :bd_haus, rate: 1
  sleep 0.5
end
```

Now, press the `Run` button and you'll hear a nice fast bass drum
beating away. If at any time you wish to stop the sound just hit the
`Stop` button. Although don't hit it just yet... Instead, follow these steps:

1. Make sure the bass drum sound is still running
2. Change the `sleep` value from `0.5` to something higher like `1`.
3. Press the `Run` button again
4. Notice how the drum speed has changed.
5. Finally, *remember this moment*, this is the first time you've live
   coded with Sonic Pi and it's unlikely to be your last...

Ok, that was simple enough. Let's add something else into the mix. Above
`sample :bd_haus` add the line `sample :ambi_choir, rate: 0.3`. Your
code should look like this:

```
live_loop :flibble do
  sample :ambi_choir, rate: 0.3
  sample :bd_haus, rate: 1
  sleep 1
end
```

Now, play around. Change the rates - what happens when you use high
values, or small values or negative values? See what happens when you
change the `rate:` value for the `:ambi_choir` sample just slightly (say
to `0.29`). What happens if you choose a really small `sleep` value? See
if you can make it go so fast your computer will stop with an error
because it can't keep up (if that happens, just choose a bigger `sleep`
time and hit `Run` again).

Try commenting one of the `sample` lines out by adding a `#` to the
beginning:

```
live_loop :flibble do
  sample :ambi_choir, rate: 0.3
#  sample :bd_haus, rate: 1
  sleep 1
end
```

Notice how it tells the computer to ignore it, so we don't hear it. This
is called a comment. In Sonic Pi we can use comments to remove and add
things into the mix.

Finally, let me leave you something fun to play with. Take the code below,
and copy it into a spare buffer. Now, don't try to understand it too
much other than see that there are two loops - so two things going round
at the same time. Now, do what you do best - experiment and play
around. Here are some suggestions:

* Try changing the blue `rate:` values to hear the sample sound change.
* Try changing the `sleep` times and hear that both loops can spin round
  at different rates.
* Try uncommenting the sample line (remove the `#`) and enjoy the sound
  of the guitar played backwards.
* Try changing any of the blue `mix:` values to numbers between `0` (not
  in the mix) and `1` (fully in the mix).

Remember to press `Run` and you'll hear the change next time the loop
goes round. If you end up in a pickle, don't worry - hit `Stop`, delete
the code in the buffer and paste a fresh copy in and you're ready to
jam again. Making mistakes is how you'll learn the quickest...


```
live_loop :guit do
  with_fx :echo, mix: 0.3, phase: 0.25 do
    sample :guit_em9, rate: 0.5
  end
#  sample :guit_em9, rate: -0.5
  sleep 8
end

live_loop :boom do
  with_fx :reverb, room: 1 do
    sample :bd_boom, amp: 10, rate: 1
  end
  sleep 8
end
```

Now, keep playing and experimenting until your curiosity about how this
all actually works kicks in and you start wondering what else you can do
with this. You're now ready to read the rest of the tutorial.

So what are you waiting for...
