
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
    Copyright 2000-2013 the Rosegarden development team.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_SCROLLBOXDIALOG_H_
#define _RG_SCROLLBOXDIALOG_H_

#include "ScrollBox.h"
#include <QDialog>


class QWidget;
class QSize;
class QCloseEvent;


namespace Rosegarden
{



class ScrollBoxDialog : public QDialog
{
    Q_OBJECT

public:
    ScrollBoxDialog(QWidget *parent = 0,
                    ScrollBox::SizeMode mode = ScrollBox::FixWidth,
                    const char *name = 0);
//                    WFlags flags = 0);
    ~ScrollBoxDialog();

    ScrollBox *scrollbox() { return m_scrollbox; }
    void setPageSize(const QSize&);
    
protected:
    virtual void closeEvent(QCloseEvent * e);

signals:
    void closed();

private:
    ScrollBox *m_scrollbox;
};



}

#endif
