#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

TMP_TEST_DB=samples.db
TMP_DB_FILE=${TMP_DB_DIR}/samples.db
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/${TMP_TEST_DB}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_FILE} <<'EOF'
create table origin (
  `id` integer AUTO_INCREMENT PRIMARY KEY,
  `uuid` char(36) NOT NULL UNIQUE,
  `location` varchar(255) DEFAULT NULL,
  `mine` varchar(255) DEFAULT NULL
); 

create table sample (
   id integer primary key autoincrement,
   uuid char(36) unique,
   SolsaID char(12) unique,
   origin_id integer foreighn key `origin_id` references origin(id),
   name text
);

insert into origin (id,uuid,location,mine) values
   (1,"616953f0-55cf-11e8-9571-537b10974660","Vilnius","Bartonys IV"),
   (2,"61697984-55cf-11e8-aceb-a7c50ce67ca6","France","SODICAPEI")
;

insert into sample (id,uuid,SolsaID,origin_id,name) values
    (1,"3129df14-4ec4-11e8-950f-cfc135e92040","VU-TEST-0001",2,"Calcite"),
    (2,"45cb6e74-4ec4-11e8-ac0e-73a678ca22dc","VU-TEST-0002",1,"Stromatolite")
;

EOF

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} <<EOF
insert into description 
    (id,dbname, dbtable, dbcolumn, coltype, fk_target, relation, visualisation)
values
    (1,"${TMP_DB_FILE_ABS}", "sample", "id", "id", NULL, NULL, NULL),
    (2,"${TMP_DB_FILE_ABS}", "origin", "id", "id", NULL, NULL, NULL),

    (3,"${TMP_DB_FILE_ABS}", "sample", "origin_id", "fk", 2, "1", "card")
;
EOF

## sqlite3 ${TMP_DB_FILE} 'select diffraction_file from experiment_xrd'
## sqlite3 ${TMP_DB_FILE} 'select image from xrd_img'

export REQUEST_URI='/~saulius/restful/website/samples.db/sample/1?filter=solsaid+CONTAINS+"VU"'
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=get
export QUERY_STRING=""
export REMOTE_USER=tester

${INPUT_SCRIPT} 'filter=solsaid+CONTAINS+"VU"'

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
