% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture-output.R
\name{capture_output}
\alias{capture_output}
\alias{capture_output_lines}
\title{Capture output to console}
\usage{
capture_output(code, print = FALSE, width = 80)

capture_output_lines(code, print = FALSE, width = 80)
}
\arguments{
\item{code}{Code to evaluate.}

\item{print}{If \code{TRUE} and the result of evaluating \code{code} is
visible this will print the result, ensuring that the output of printing
the object is included in the overall output}

\item{width}{Number of characters per line of output}
}
\value{
\code{capture_output()} returns a single string. \code{capture_output_lines()}
returns a character vector with one entry for each line
}
\description{
Evaluates \code{code} in a special context in which all output is captured,
similar to \code{\link[=capture.output]{capture.output()}}.
}
\examples{
capture_output({
  cat("Hi!\\n")
  cat("Bye\\n")
})

capture_output_lines({
  cat("Hi!\\n")
  cat("Bye\\n")
})

capture_output("Hi")
capture_output("Hi", print = TRUE)
}
\keyword{internal}
