% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_aweek.R
\name{factor_aweek}
\alias{factor_aweek}
\title{Coerce an aweek object to factor to include missing weeks}
\usage{
factor_aweek(x)
}
\arguments{
\item{x}{an aweek object}
}
\value{
an aweek object that inherits from \code{\link[=factor]{factor()}} with levels that span
the range of the weeks in the object.
}
\description{
Coerce an aweek object to factor to include missing weeks
}
\note{
when factored aweek objects are combined with other aweek objects, they
are converted back to characters.
}
\examples{
w <- get_aweek(week = (1:2) * 5, year = 2019, day = c(7, 1))
w
wf <- factor_aweek(w)
wf

# factors are destroyed if combined with aweek objects
c(w, wf)
}
