% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{recycleHdf5Files}
\alias{recycleHdf5Files}
\title{Recycle existing HDF5 files}
\usage{
recycleHdf5Files(recycle)
}
\arguments{
\item{recycle}{Whether to recycle existing files for HDF5-backed DelayedArrays.}
}
\value{
Logical scalar indicating whether HDF5 files are to be reused.
If \code{recycle} is supplied, it is used to set this scalar, and the \emph{previous} value of the scalar is invisibly returned.
}
\description{
Re-use existing files in HDF5-backed arrays rather than reserializing them in \code{\link{stageObject}}.
}
\details{
If this options is enabled, \code{stageObject} will attempt to link/copy existing files for any HDF5-backed DelayedArray instances -
most specifically, \linkS4class{HDF5Array} objects and \linkS4class{H5SparseMatrix} objects using the 10X format.
This avoids re-serialization of the data for faster staging.
It also allows advanced users to add their own customizations into the HDF5 file during staging, as long as they do not interfere with \code{\link{loadArray}}.

By default, this option is disabled as the properties of the existing file are not known in the general case.
In particular, the file might contain other groups/datasets that are irrelevant, and use up extra disk space if copied; or confidential, and should not be stored in the staging directory.
Users should only enable this option if they have full control over the generation and contents of the backing HDF5 files.

Also note that any dimnames on \code{x} will be ignored during recycling.
}
\examples{
recycleHdf5Files()
old <- recycleHdf5Files(TRUE)
recycleHdf5Files()
recycleHdf5Files(old)

}
\author{
Aaron Lun
}
