#!/usr/bin/env python3
import sys
from pathlib import Path

try:
    import tomllib
except ImportError:
    import tomli as tomllib

repo_root = Path(__file__).parent.parent
pyproject_toml = repo_root / 'pyproject.toml'
reqs = repo_root / 'requirements.txt'
min_reqs = repo_root / 'min-requirements.txt'

with open(pyproject_toml, 'rb') as fobj:
    config = tomllib.load(fobj)
    project = config['project']
requirements = project['dependencies'] + project['optional-dependencies']['full']

script_name = Path(__file__).relative_to(repo_root)

lines = [
    f'# Auto-generated by {script_name}',
    '--only-binary numpy,scipy',
    '--extra-index-url https://pypi.anaconda.org/scientific-python-nightly-wheels/simple',
    '',
]
start = len(lines) - 1

# Write requirements
lines[start:-1] = requirements
reqs.write_text('\n'.join(lines))

# Write minimum requirements
lines[start:-1] = [req.replace('>=', '==').replace('~=', '==') for req in requirements]
min_reqs.write_text('\n'.join(lines))
