/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.actions;

import ancestris.modules.editors.aries.AriesTopComponent;
import ancestris.modules.editors.aries.editors.SubmitterEditor;
import ancestris.view.AncestrisTopComponent;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Submitter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class AriesCreateSubmitterAction
implements ActionListener {
    private final DataObject context;
    private Submitter mSubmitter;

    public AriesCreateSubmitterAction(DataObject context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Context gedcomContext = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (gedcomContext != null) {
            Gedcom gedcom = gedcomContext.getGedcom();
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            if (atc == null) {
                AncestrisTopComponent win = new AriesTopComponent().create(gedcomContext);
                win.open();
                win.requestActive();
            }
            try {
                gedcom.doUnitOfWork(gedcom1 -> {
                    this.mSubmitter = (Submitter)gedcom1.createEntity("SUBM");
                });
                SubmitterEditor submitterEditor = new SubmitterEditor(true);
                submitterEditor.setContext(new Context((Entity)this.mSubmitter));
                if (!submitterEditor.showPanel()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

