/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.placeeditor.topcomponents;

import ancestris.core.beans.ConfirmChangeWidget;
import ancestris.modules.editors.placeeditor.topcomponents.CellsData;
import ancestris.modules.editors.placeeditor.topcomponents.CellsTransferHandler;
import ancestris.swing.atable.ATableHeaderRenderer;
import ancestris.swing.atable.ATableRowSorter;
import genj.gedcom.Gedcom;
import genj.util.ChangeSupport;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.TextAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.WindowManager;

public class EditorTable
extends JTable
implements FocusListener {
    private Registry registry = null;
    private String mTableId = null;
    private ATableRowSorter<TableModel> sorter;
    private boolean dragingColumnCompleted = false;
    private int fromIndex = -1;
    private int toIndex = -1;
    private final List<Action> actions = new ArrayList<Action>();
    protected ChangeSupport changes = new ChangeSupport((Object)this);
    private String Copy_or_Move_Action = "";
    private boolean pendingPaste = false;
    private int[] rowsSelectedAtExport = null;
    private int[] colsSelectedAtExport = null;

    public EditorTable() {
        this.addAction(new CutAction(), 88, "cut-to-clipboard", new ImageIcon(ImageUtilities.loadImage((String)"org/openide/resources/actions/cut.gif")));
        this.addAction(new CopyAction(), 67, "copy-to-clipboard", new ImageIcon(ImageUtilities.loadImage((String)"org/openide/resources/actions/copy.gif")));
        this.addAction(new PasteAction(), 86, "paste-from-clipboard", new ImageIcon(ImageUtilities.loadImage((String)"org/openide/resources/actions/paste.gif")));
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON);
        this.setTransferHandler(new CellsTransferHandler(this));
        this.addPropertyChangeListener("dropLocation", new Repainter());
        this.setDefaultRenderer(Object.class, new MyTableCellRenderer());
    }

    private void addAction(TextAction action, int key, String text, ImageIcon icon) {
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key, 128));
        action.putValue("Name", NbBundle.getMessage(this.getClass(), (String)text));
        action.putValue("SmallIcon", icon);
        this.getActionMap().put(text, action);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(key, 128), text);
        this.actions.add(action);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setID(Gedcom gedcom, String tableId, int selectedColumn) {
        this.registry = gedcom.getRegistry();
        this.mTableId = tableId;
        this.setColumnOrder();
        if (selectedColumn < 0 || selectedColumn > this.columnModel.getColumnCount()) {
            selectedColumn = 0;
        }
        for (int index = 0; index < this.columnModel.getColumnCount(); ++index) {
            int columnSize = this.registry.get(this.mTableId + ".column" + index + ".size", 100);
            this.columnModel.getColumn(index).setPreferredWidth(columnSize);
        }
        Collator collator = gedcom.getCollator();
        Comparator strComparator = (o1, o2) -> collator.compare(o1.replace(" ", "!"), o2.replace(" ", "!"));
        this.sorter = new ATableRowSorter(this.getModel());
        for (int c = 0; c < this.getColumnModel().getColumnCount(); ++c) {
            this.sorter.setComparator(c, strComparator);
        }
        this.setRowSorter((RowSorter<? extends TableModel>)this.sorter);
        this.getTableHeader().setDefaultRenderer((TableCellRenderer)new ATableHeaderRenderer(this.getTableHeader().getDefaultRenderer()));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent aEvent) {
                if (EditorTable.this.sorter != null) {
                    int columnIdx = EditorTable.this.convertColumnIndexToModel(EditorTable.this.getColumnModel().getColumnIndexAtX(aEvent.getX()));
                    if (!aEvent.isControlDown()) {
                        EditorTable.this.sorter.toggleSortOrder(columnIdx, true);
                    } else {
                        EditorTable.this.sorter.toggleSortOrder(columnIdx, false);
                    }
                    EditorTable.this.registry.put("placeTableSortOrder", EditorTable.this.getSortOrder());
                }
            }
        });
        String sortOrder = this.registry.get("placeTableSortOrder", "");
        List<Object> sortKeys = new ArrayList<RowSorter.SortKey>();
        this.sorter.setMaxSortKeys(this.getColumnCount());
        if (sortOrder.isEmpty()) {
            sortKeys.add(new RowSorter.SortKey(selectedColumn, SortOrder.ASCENDING));
            for (int c = 0; c < this.getColumnCount(); ++c) {
                if (c == selectedColumn) continue;
                sortKeys.add(new RowSorter.SortKey(c, SortOrder.ASCENDING));
            }
        } else {
            sortKeys = this.setSortOrder(sortOrder, this.getColumnCount());
        }
        this.sorter.setSortKeys(sortKeys);
        this.sorter.sort();
        this.getColumnModel().addColumnModelListener(new EditorTableTableColumnModelListener());
        this.getTableHeader().setReorderingAllowed(true);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (EditorTable.this.dragingColumnCompleted && EditorTable.this.fromIndex != EditorTable.this.toIndex) {
                    EditorTable.this.saveColumnOrder();
                }
                EditorTable.this.fromIndex = -1;
                EditorTable.this.dragingColumnCompleted = false;
            }
        });
        this.getModel().addTableModelListener(e -> {
            this.changes.setChanged(true);
            if (ConfirmChangeWidget.getAutoCommit()) {
                WindowManager.getDefault().invokeWhenUIReady(() -> this.changes.stateChanged(new ChangeEvent(true)));
            }
        });
        this.changes.setChanged(false);
    }

    public void saveColumnOrder() {
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            this.registry.put(this.mTableId + ".column" + i + ".pos", this.convertColumnIndexToModel(i));
        }
    }

    public void setColumnOrder() {
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            int pos = this.convertColumnIndexToView(this.registry.get(this.mTableId + ".column" + i + ".pos", i));
            if (pos >= this.columnModel.getColumnCount() || pos < 0) continue;
            this.columnModel.moveColumn(pos, i);
        }
    }

    private String getSortOrder() {
        ArrayList keys = new ArrayList(this.sorter.getSortKeys());
        Object ret = "";
        for (RowSorter.SortKey key : keys) {
            ret = (String)ret + key.getColumn() + "," + key.getSortOrder().name() + ";";
        }
        return ret;
    }

    private List<RowSorter.SortKey> setSortOrder(String sortOrder, int colNb) {
        String[] keyBits;
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.sorter.getSortKeys());
        for (String keyPairs : keyBits = sortOrder.split(";")) {
            int col;
            String[] keyBits2 = keyPairs.split(",");
            if (keyBits2.length != 2 || (col = Integer.parseInt(keyBits2[0])) < 0 || col >= colNb) continue;
            keys.add(new RowSorter.SortKey(col, SortOrder.valueOf(keyBits2[1])));
        }
        return keys;
    }

    public TableRowSorter<TableModel> getSorter() {
        return this.sorter;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changes.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changes.removeChangeListener(listener);
    }

    @Override
    public void focusGained(FocusEvent e) {
        for (Action a : this.actions) {
            a.setEnabled(true);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        for (Action a : this.actions) {
            a.setEnabled(false);
        }
    }

    public static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    public Object[][] exportData() {
        int j;
        int i;
        this.rowsSelectedAtExport = this.getSelectedRows();
        this.colsSelectedAtExport = this.getSelectedColumns();
        int[] rows = this.rowsSelectedAtExport;
        int[] cols = this.colsSelectedAtExport;
        int dimRow = rows[rows.length - 1] - rows[0] + 1;
        int dimCol = cols[cols.length - 1] - cols[0] + 1;
        Object[][] data = new Object[dimRow][dimCol];
        for (i = 0; i < dimRow; ++i) {
            for (j = 0; j < dimCol; ++j) {
                data[i][j] = null;
            }
        }
        for (i = 0; i < rows.length; ++i) {
            for (j = 0; j < cols.length; ++j) {
                data[rows[i] - rows[0]][cols[j] - cols[0]] = this.getValueAt(rows[i], cols[j]);
            }
        }
        return data;
    }

    public void importData(Object[][] data, int[] rows, int[] cols) {
        int maxRow = data.length;
        int maxCol = data[0].length;
        int r = 0;
        int c = 0;
        this.clearSelection();
        if (rows.length + cols.length <= 2) {
            for (int i = 0; i < maxRow; ++i) {
                for (int j = 0; j < maxCol; ++j) {
                    if (rows[0] + i >= this.getRowCount() || cols[0] + j >= this.getColumnCount()) continue;
                    r = rows[0] + i;
                    c = cols[0] + j;
                    this.setValueAt(data[i][j], r, c);
                }
            }
        } else {
            for (int i = 0; i < rows.length; ++i) {
                for (int j = 0; j < cols.length; ++j) {
                    this.setValueAt(data[i % maxRow][j % maxCol], rows[i], cols[j]);
                }
            }
        }
        this.selectDraggedCells(rows[0], cols[0]);
        this.resetPendingPaste();
    }

    public void eraseSelection() {
        int[] rows = this.rowsSelectedAtExport;
        int[] cols = this.colsSelectedAtExport;
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                this.setValueAt("", rows[i], cols[j]);
            }
        }
    }

    private void selectDraggedCells(int row, int column) {
        this.clearSelection();
        int[] sRows = this.rowsSelectedAtExport;
        int[] sCols = this.colsSelectedAtExport;
        if (sRows == null || sCols == null) {
            return;
        }
        int r = 0;
        int c = 0;
        for (int i = 0; i < sRows.length; ++i) {
            for (int j = 0; j < sCols.length; ++j) {
                r = row + sRows[i] - sRows[0];
                c = column + sCols[j] - sCols[0];
                if (r < this.getRowCount()) {
                    this.addRowSelectionInterval(r, r);
                }
                if (c >= this.getColumnCount()) continue;
                this.addColumnSelectionInterval(c, c);
            }
        }
    }

    public void setpendingPaste(boolean setTimer) {
        this.pendingPaste = true;
        this.repaint();
        if (setTimer) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    EditorTable.this.resetPendingPaste();
                }
            }, 12000L);
        }
    }

    public void resetPendingPaste() {
        this.pendingPaste = false;
        this.repaint();
    }

    private boolean isDraggedCell(int row, int column) {
        int[] rows = this.rowsSelectedAtExport;
        int[] cols = this.colsSelectedAtExport;
        if (rows == null || cols == null) {
            return false;
        }
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                if (rows[i] != row || cols[j] != column) continue;
                return true;
            }
        }
        return false;
    }

    private class CutAction
    extends DefaultEditorKit.CutAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (EditorTable.this.getSelectedRow() > -1) {
                Clipboard clipboard = EditorTable.getClipboard();
                clipboard.setContents(new CellsData(EditorTable.this.exportData()), null);
                EditorTable.this.setpendingPaste(true);
                EditorTable.this.Copy_or_Move_Action = "cut-to-clipboard";
            }
        }
    }

    private class CopyAction
    extends DefaultEditorKit.CopyAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (EditorTable.this.getSelectedRow() > -1) {
                Clipboard clipboard = EditorTable.getClipboard();
                clipboard.setContents(new CellsData(EditorTable.this.exportData()), null);
                EditorTable.this.setpendingPaste(true);
                EditorTable.this.Copy_or_Move_Action = "copy-to-clipboard";
            }
        }
    }

    private class PasteAction
    extends DefaultEditorKit.PasteAction {
        public PasteAction() {
            Clipboard clipboard = EditorTable.getClipboard();
            clipboard.addFlavorListener(e -> this.setEnabled(clipboard.isDataFlavorAvailable(CellsData.CELL_DATA_FLAVOR)));
            this.setEnabled(clipboard.isDataFlavorAvailable(CellsData.CELL_DATA_FLAVOR));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = EditorTable.getClipboard();
            if (clipboard.isDataFlavorAvailable(CellsData.CELL_DATA_FLAVOR)) {
                try {
                    if (EditorTable.this.Copy_or_Move_Action.equals("cut-to-clipboard")) {
                        EditorTable.this.eraseSelection();
                    }
                    Object[][] data = (Object[][])clipboard.getData(CellsData.CELL_DATA_FLAVOR);
                    EditorTable.this.importData(data, EditorTable.this.getSelectedRows(), EditorTable.this.getSelectedColumns());
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class Repainter
    implements PropertyChangeListener {
        private Repainter() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JTable.DropLocation oldLoc = (JTable.DropLocation)evt.getOldValue();
            JTable.DropLocation newLoc = (JTable.DropLocation)evt.getNewValue();
            if (oldLoc != null && newLoc != null && (newLoc.getRow() != oldLoc.getRow() || newLoc.getColumn() != oldLoc.getColumn())) {
                EditorTable.this.selectDraggedCells(newLoc.getRow(), newLoc.getColumn());
            }
        }
    }

    private class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private Color color = new Color(UIManager.getColor("Table.background").getRGB());
        private Color selectedRowColor = new Color(UIManager.getColor("Table.dropLineColor").getRGB());

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean isSelectedRow;
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean bl = isSelectedRow = table.getSelectedRow() == row;
            if (EditorTable.this.pendingPaste && EditorTable.this.isDraggedCell(row, column)) {
                c.setBackground(new Color(255, 166, 77));
            } else if (isSelected) {
                c.setBackground(table.getSelectionBackground());
            } else if (isSelectedRow) {
                c.setBackground(this.selectedRowColor);
            } else {
                c.setBackground(this.color);
            }
            return c;
        }
    }

    private class EditorTableTableColumnModelListener
    implements TableColumnModelListener {
        private EditorTableTableColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tcme) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tcme) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (EditorTable.this.fromIndex == -1) {
                EditorTable.this.fromIndex = e.getFromIndex();
            }
            EditorTable.this.toIndex = e.getToIndex();
            EditorTable.this.dragingColumnCompleted = true;
        }

        @Override
        public void columnMarginChanged(ChangeEvent ce) {
            for (int index = 0; index < EditorTable.this.columnModel.getColumnCount(); ++index) {
                EditorTable.this.registry.put(EditorTable.this.mTableId + ".column" + index + ".size", EditorTable.this.columnModel.getColumn(index).getPreferredWidth());
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent lse) {
        }
    }
}

