/*
 * Decompiled with CFR 0.152.
 */
package genj.fo;

import ancestris.util.GedcomUtilities;
import genj.fo.Document;
import genj.fo.Format;
import genj.util.EnvironmentChecker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.apache.fop.fo.FOTreeBuilder;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.autodetect.WindowsFontDirFinder;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFUtil;
import org.openide.util.Exceptions;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class PDFFormat
extends Format {
    private static final Logger LOG = Logger.getLogger("ancestris.PDFFormat");

    public PDFFormat() {
        super("PDF", "pdf", false);
    }

    @Override
    protected void formatImpl(Document doc, OutputStream out) throws Throwable {
        File file = this.generateConfigurationFile();
        if (file == null) {
            return;
        }
        DefaultConfigurationBuilder config = new DefaultConfigurationBuilder();
        DefaultConfiguration conf = config.buildFromFile(file);
        FopFactoryBuilder builder = new FopFactoryBuilder(new File(".").toURI());
        builder.setStrictFOValidation(false);
        builder.setAccessibility(true);
        builder.setConfiguration((Configuration)conf);
        FopFactory fopF = builder.build();
        FOUserAgent foUserAgent = fopF.newFOUserAgent();
        FOTreeBuilder handler = new FOTreeBuilder("application/pdf", foUserAgent, out);
        this.secureFontName(doc, foUserAgent);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(doc.getDOMSource(), new SAXResult((ContentHandler)handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generateConfigurationFile() {
        List<File> dirs = null;
        if (EnvironmentChecker.isWindows()) {
            dirs = this.getWindowsFontDirectories();
        } else if (EnvironmentChecker.isMac()) {
            dirs = this.getMacFontDirectories();
        } else if (EnvironmentChecker.isLinux()) {
            dirs = this.getLinuxFontDirectories();
        }
        File file = null;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String resourceFile = "resources/fopPdfConfiguration.xml";
            InputStream inputStream = this.getClass().getResourceAsStream(resourceFile);
            reader = new BufferedReader(new InputStreamReader(inputStream));
            file = File.createTempFile("fopPdfConfiguration", ".xml");
            file.deleteOnExit();
            writer = new BufferedWriter(new FileWriter(file));
            while (reader.ready()) {
                String inputLine = reader.readLine();
                if (inputLine.contains("%DIR%")) {
                    if (dirs.isEmpty()) {
                        LOG.warning("Fonts directories not found. Ancestris will use default fonts for the PDF output. Please contact Ancestris forum.");
                        writer.write("                <auto-detect/>");
                        writer.newLine();
                        continue;
                    }
                    for (File dir : dirs) {
                        LOG.info("Checking fonts directory " + dir.getAbsolutePath() + "...");
                        String outputLine = inputLine.replaceAll("%DIR%", dir.getAbsolutePath().replace("\\", "\\\\"));
                        writer.write(outputLine);
                        writer.newLine();
                    }
                    continue;
                }
                writer.write(inputLine);
                writer.newLine();
            }
            File file2 = file;
            return file2;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                reader.close();
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return file;
    }

    private List<File> getWindowsFontDirectories() {
        WindowsFontDirFinder finder = new WindowsFontDirFinder();
        return finder.find();
    }

    private List<File> getMacFontDirectories() {
        String[] paths = new String[]{"/System/Library/Fonts/", "/Network/Library/Fonts/", "/Library/Fonts/", System.getProperty("user.home") + "/Library/Fonts/"};
        return this.getFilesFromPaths(paths);
    }

    private List<File> getLinuxFontDirectories() {
        File[] fileArray;
        int n;
        int n2;
        String userDir = System.getProperty("user.home");
        String version = System.getProperty("java.version");
        String fs = File.separator;
        String dir = userDir + fs + ".java" + fs + "fonts" + fs + version;
        File dirFile = new File(dir);
        File propertiesFile = null;
        if (dirFile.exists() && dirFile.canRead() && (n2 = 0) < (n = (fileArray = dirFile.listFiles((dir1, name) -> name.endsWith(".properties"))).length)) {
            File f;
            propertiesFile = f = fileArray[n2];
            LOG.info("Font properties file found: " + f.getAbsolutePath());
        }
        HashSet<Object> fontDirs = new HashSet<Object>();
        if (propertiesFile != null) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(propertiesFile));
                prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (k.toString().endsWith(".file")) {
                        String fileStr = v.toString();
                        String path = fileStr.substring(0, fileStr.lastIndexOf("/"));
                        if (!path.endsWith("/fonts")) {
                            path = path.substring(0, path.lastIndexOf("/"));
                        }
                        if (!path.equals(userDir)) {
                            fontDirs.add(path);
                        } else {
                            LOG.info("Excluding home directory: " + path);
                        }
                    }
                }));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        LOG.info("Adding usual directories...");
        fontDirs.add("/usr/share/fonts");
        fontDirs.add("/usr/local/share/fonts");
        fontDirs.add("/usr/X11R6/lib/X11/fonts");
        fontDirs.add(System.getProperty("user.home") + "/.local/share/fonts");
        fontDirs.add(System.getProperty("user.home") + "/.fonts");
        String[] paths = (String[])fontDirs.toArray(String[]::new);
        return this.getFilesFromPaths(paths);
    }

    private List<File> getFilesFromPaths(String[] paths) {
        ArrayList<File> ret = new ArrayList<File>();
        for (String path : paths) {
            File f = new File(path);
            if (!f.exists() || !f.canRead()) continue;
            ret.add(f);
        }
        return ret;
    }

    private void secureFontName(Document doc, FOUserAgent foUserAgent) throws FOPException {
        FontInfo fontInfo = new FontInfo();
        IFDocumentHandler documentHandler = foUserAgent.getRendererFactory().createDocumentHandler(foUserAgent, "application/pdf");
        IFUtil.setupFonts((IFDocumentHandler)documentHandler, (FontInfo)fontInfo);
        Map registeredTriplets = fontInfo.getFontTriplets();
        HashSet<String> fontNames = new HashSet<String>();
        for (Object triplet : registeredTriplets.keySet()) {
            if (!triplet.getStyle().equals("normal")) continue;
            fontNames.add(triplet.getName());
        }
        ArrayList names = new ArrayList(fontNames);
        Collections.sort(names);
        for (String name : names) {
            LOG.fine("Registered 'normal' font name " + name);
        }
        org.w3c.dom.Document domDoc = doc.getDomDoc();
        Element rootElement = domDoc.getDocumentElement();
        String fontName = rootElement.getAttribute("font-family");
        if (!fontNames.contains(fontName)) {
            LOG.info("Unfound font name " + fontName);
            fontName = fontName.replaceAll(" ", "-");
            if (fontNames.contains(fontName)) {
                LOG.info("Match is " + fontName);
                rootElement.setAttribute("font-family", fontName);
                doc.setDomDoc(domDoc);
            } else {
                int score = 0;
                String foundName = "";
                for (String name : fontNames) {
                    int s = GedcomUtilities.similarity((String)name, (String)fontName, (int)3);
                    if (s <= score) continue;
                    score = s;
                    foundName = name;
                }
                if (score > 60) {
                    LOG.info("Best match is " + foundName + " (score=" + score + "%)");
                    rootElement.setAttribute("font-family", foundName);
                    doc.setDomDoc(domDoc);
                } else {
                    LOG.info("Best match " + foundName + " not retained.");
                }
            }
        } else {
            LOG.info("Font name " + fontName + " found in registered fonts.");
        }
    }
}

