/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.swing.UndoTextPane;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class NoteDetailsPanel
extends JPanel {
    private Registry registry = Registry.get(this.getClass());
    private StyledDocument doc;
    private Style style;
    private int fontSize = 12;
    private JButton growFont;
    private JTextPane noteText;
    private JScrollPane scrollPane;
    private JButton shrinkFont;
    private JPanel textPanel;

    public NoteDetailsPanel() {
        this.initComponents();
        this.initSize();
        this.doc = (StyledDocument)this.noteText.getDocument();
        this.style = this.doc.addStyle("StyleName", null);
    }

    private void redisplayText() {
        String selText = this.noteText.getSelectedText();
        int start = this.noteText.getSelectionStart();
        int end = this.noteText.getSelectionEnd();
        String tmpText = this.noteText.getText();
        StyleConstants.setFontSize(this.style, this.fontSize);
        try {
            this.doc.remove(0, tmpText.length());
            this.doc.insertString(0, tmpText, this.style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.noteText.setSelectionStart(start);
        this.noteText.setSelectionEnd(end);
        this.noteText.scrollToReference(selText != null ? selText : tmpText.substring(start, start));
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                NoteDetailsPanel.this.noteText.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.growFont = new JButton();
        this.shrinkFont = new JButton();
        this.textPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.noteText = new UndoTextPane();
        this.setPreferredSize(new Dimension(500, 400));
        this.growFont.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/standard/images/growfont.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.growFont, (String)NbBundle.getMessage(NoteDetailsPanel.class, (String)"NoteDetailsPanel.growFont.text"));
        this.growFont.setPreferredSize(new Dimension(32, 32));
        this.growFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteDetailsPanel.this.growFontActionPerformed(evt);
            }
        });
        this.shrinkFont.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/standard/images/shrinkfont.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.shrinkFont, (String)NbBundle.getMessage(NoteDetailsPanel.class, (String)"NoteDetailsPanel.shrinkFont.text"));
        this.shrinkFont.setPreferredSize(new Dimension(32, 32));
        this.shrinkFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteDetailsPanel.this.shrinkFontActionPerformed(evt);
            }
        });
        this.textPanel.setBorder(BorderFactory.createEtchedBorder());
        this.scrollPane.setViewportView(this.noteText);
        GroupLayout textPanelLayout = new GroupLayout(this.textPanel);
        this.textPanel.setLayout(textPanelLayout);
        textPanelLayout.setHorizontalGroup(textPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 484, Short.MAX_VALUE));
        textPanelLayout.setVerticalGroup(textPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, textPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scrollPane, -1, 346, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.growFont, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shrinkFont, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.growFont, -2, -1, -2).addComponent(this.shrinkFont, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void growFontActionPerformed(ActionEvent evt) {
        ++this.fontSize;
        this.redisplayText();
    }

    private void shrinkFontActionPerformed(ActionEvent evt) {
        --this.fontSize;
        this.redisplayText();
    }

    public void setText(String text) {
        this.initSize();
        this.noteText.setText(text);
        this.noteText.setCaretPosition(0);
        this.redisplayText();
    }

    public String getText() {
        this.saveSize();
        return this.noteText.getText();
    }

    private void initSize() {
        this.setPreferredSize(new Dimension(this.registry.get("noteEditorWidth", this.getPreferredSize().width), this.registry.get("noteEditorHeight", this.getPreferredSize().height)));
    }

    private void saveSize() {
        int h;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        if (w > dim.width * 8 / 10) {
            w = dim.width * 8 / 10;
        }
        if ((h = this.getSize().height) > dim.height * 8 / 10) {
            h = dim.height * 8 / 10;
        }
        this.registry.put("noteEditorWidth", w);
        this.registry.put("noteEditorHeight", h);
    }
}

