#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import csv,getpass,xmlrpclib,sys

adresse_zephir='192.168.230.67'
# liste des valeurs à récupérer par module (à compléter)
liste_vars = {'horus-1.0':['adresse_ip_eth0','numero_etab'],
              'amon-1.5':[]
             }

# format des lignes csv:
# rne;libelle;materiel;processeur;disque_dur;date_install;installateur;tel;remarques;libelle_module;delai de connexion;creole_values
# date install JJ/MM/AAAA ou format du type time.ctime() en python
# delai en secondes
# creole_values : valeur1,valeur2,... (doit correspondre à ce qui est défini dans liste_vars).

# délimiteur de champ
delimiter = ';'
# délimiteur dans la liste des variables
var_delimiter = ','

def import_serveurs():

    login = raw_input('login zephir :')
    passwd = getpass.getpass('mot de passe :')
    # lecture du fichier csv
    fic_csv_name = raw_input('emplacement du fichier csv : ')
    fic_csv = open(fic_csv_name)
    parser = csv.reader(fic_csv,delimiter=delimiter)


    proxy = xmlrpclib.ServerProxy('https://%s:%s@%s:7080' % (login,passwd,adresse_zephir))

    # informations sur les module et variantes
    modules = {}
    variantes = {}
    try:
        # liste des variantes standard par module
        for var in proxy.modules.get_variante()[1]:
            if var['libelle'] == 'standard':
                variantes[var['module']] = var['id']
        for mod in proxy.modules.get_module()[1]:
            # correspondance libelle de module/n° de module
            modules[mod['libelle']] = (mod['id'],variantes[mod['id']])
    except:
        sys.exit('erreur de lecture des informations sur les modules')

    # parsing des données
    erreurs = []
    while True:
        try:
            data_server = parser.next()
        except StopIteration:
            # fin du fichier
            fic_csv.close()
            break
        # traitement des données
        rne, libelle, materiel, processeur, disque_dur, date_install, installateur, tel, remarques, module, delay, creole_values = data_server
        # par défaut, la variante standard est utilisée
        # ajout du serveur
        try:
            id_mod = modules[module][0]
            variante = modules[module][1]
            code, res = proxy.serveurs.add_serveur(rne, libelle, materiel, processeur, disque_dur,date_install, installateur, tel, remarques, id_mod, id_mod, delay, variante)
            if code == 0:
                raise Exception, res
            id_serveur = int(res)
            print "serveur ajouté %s : %s" % (libelle,id_serveur)
        except Exception, e:
            print "erreur d'ajout du serveur %s : %s" % (libelle, str(e))
            erreurs.append(delimiter.join(data_server))
        else:
            # mise en place des données de configuration
            num_var = 0
            values = creole_values.split(',')
            if len(values) != len(liste_vars[module]):
                print "serveur %s : nombre de variable incorrect" % libelle
            else:
                for varname in liste_vars[module]:
                    value = values[num_var]
                    code, res = proxy.serveurs.set_groupe_var([id_serveur],varname,value,True)
                    num_var += 1
                    if code == 0:
                        print "serveur %s : erreur d'insertion de la variable %s (%s) : %s" % (libelle, varname, value, str(res))

    # on stocke dans un fichier csv les serveurs non ajoutés
    if len(erreurs) > 0:
        f=open("error.csv","w")
        f.write('\n'.join(erreurs))
        f.close()

if __name__ == '__main__':
    import_serveurs()
