#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""Un agent de listing (pour les tests)
"""

from agent import Agent

class ListAgent(Agent):
    """Liste un répertoire courant
    """
    def __init__(self):
        self.name="ls"
        self.description="""Listing des fichiers d'un répertoire"""
        Agent.__init__(self)
        # écriture dans les fichiers
        self.write_html()
        self.write_xml()

    HTML = """
<div class="titlediv">
<h1 class="newstitle">
</h1>
<a name="%s"/>
</div>
<div class="bodydiv">
%s
</div>
"""
    def _ls(self):
        """Récupère la sortie de ls
        """
        return resultat
        
    def _dump_xml(self):
        """
        Formatage xml du résultat
        """
        liste_resultat = self._ls()
        l = ["""  <ul>"""]
        for elt in liste_resultat:
            l.append("""    <li>%s</li>""" % elt.rstrip())

        l.append("""  </ul>""")
        return "\n".join(l)

    def _dump_html(self):
        """Formatage html du résultat 
        """
        return self.HTML % (self.name, self._dump_xml())
    
if __name__ == "__main__":
    ListAgent()
