# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# services_rpc.py
#  
# fonctions xmlrpc pour la gestion des services dans Zephir
#       
###########################################################################
"""module de gestion des services
"""
from zephir.backend.db_utils import *
from zephir.backend import config
from zephir.backend.config import u
from zephir.backend.xmlrpceole import XMLRPCEole as XMLRPC

import sys,os,shutil

class RPCServices(XMLRPC):
    """serveur XMLRPC zephir pour la gestion des bases de données
    """

    def __init__(self,parent):
        self.dbpool = db_connect()
        self.dbpool.noisy = 0
        XMLRPC.__init__(self)
        self.parent = parent


    def _got_service(self, services):
        """Récupération des services du backend
        """
        l=[]
        for service in services:
            l.append({'id' : service[0], 'module' : service[1], 'libelle' : service[2]})
        return 1,u(l)

    def _got_service_installe(self, services_installes):
        """Récupération des services du backend
        """
        l=[]
        for service in services_installes:
            l.append({'id_serveur' : service[0], 'id_service' : service[1]})
        return 1,u(l)
    
    def xmlrpc_add_service(self,cred_user, module, libelle):
        """ajoute un service à un module"""
        # on vérifie qu'on a bien récupéré un serveur
        if (libelle and module):
            query = """insert into services (module,libelle) values (%s,%s)"""
            # on effectue l'insertion (l'existence est à tester dans l'application cliente)
            return self.dbpool.runOperation(query, (int(module), libelle)).addCallbacks(self._add_service,db_client_failed,callbackArgs=[module,libelle])
        else:
            # des attributs manquent
            return 0,u("""donnez un id de module et un libellé""")

    def _add_service(self,resultat,module,libelle):
        """récupère l'id attribué au service créé"""
        # on retourne l'id du service créé
        query = """select id from services where module=%s and libelle=%s"""
        return self.dbpool.runQuery(query, (int(module), libelle)).addCallbacks(lambda x:(1,x[0][0]),db_client_failed)

    def xmlrpc_del_service(self,cred_user,id_service):
        """suppression d'un service"""
        if id_service:
            query = """delete from services where id=%s"""
            # suppression du service dans la base de données
            return self.dbpool.runOperation(query, (int(id_service),)).addCallbacks(lambda x:(1,'ok'), db_client_failed)
        else:
            return 0,u("""donnez un id de service""")

    def xmlrpc_get_service(self,cred_user,id_service=None):
        """liste d'un service particulier (de tous les services)"""
        if id_service :
            query= """select * from services where id = %s"""
            return self.dbpool.runQuery(query, (int(id_service),)).addCallbacks(self._got_service,db_client_failed)
        else :
            query= """select * from services"""
            return self.dbpool.runQuery(query).addCallbacks(self._got_service,db_client_failed)

    def xmlrpc_get_service_module(self,cred_user,id_module=None):
        """liste des services d'un module (de tous les services)"""
        if id_module :
            query= """select * from services where module = %s""" % id_module
            return self.dbpool.runQuery(query, (int(id_module),)).addCallbacks(self._got_service,db_client_failed)
        else :
            query= """select * from services"""
            return self.dbpool.runQuery(query).addCallbacks(self._got_service,db_client_failed)


    def xmlrpc_edit_service(self,cred_user,id_service,dico_modifs):
        """modification d'un service
        cette fonction prend en compte un dictionnaire qui indique les 
        champs à modifier et leur nouvelle valeur. l'application cliente
        doit s'assurer que ces champs existent dans la base"""
        # on vérifie que l'identifiant n'est pas modifié
        if dico_modifs == {}:
            return 1,u("""aucune modification demandée""")
        if ('id' in dico_modifs.keys()) or ('module' in dico_modifs.keys()):
            return 0,u("""l'identifiant et le module ne peuvent pas être modifiés""")
        # construction de la requête SQL de modification
        requete = ["update services set "]
        params = []
        for cle in dico_modifs.keys():
            requete.append(str(cle))
            requete.append("=%s, ")
            params.append(str(dico_modifs[cle]))
        string_fin=""" where id=%s"""
        params.append(int(id_service))
        query="".join(requete)[:-2]
        query += string_fin
        return self.dbpool.runOperation(query, params).addCallbacks(lambda x:(1,'ok'), db_client_failed)


    ####################################################
    ## gestion des services **installes** sur un serveur
    ####################################################

    def xmlrpc_add_service_installe(self,cred_user, id_service=None, id_serveur=None):
        """ajout d'un serveur a un établissement"""
        # on vérifie qu'on a bien récupéré un serveur et un service
        if id_service and id_serveur:
            query = """insert into services_installes (id_service,id_serveur) values (%s,%s)"""
            # on effectue l'insertion (l'existence est à tester dans l'application cliente)
            params = (int(id_service), int(id_serveur))
            return self.dbpool.runOperation(query, params).addCallbacks(lambda x:(1,'ok'), db_client_failed)
        else:
            # des attributs manquent
            return 0,u("""donnez un id de service et un id de serveur""")

    def xmlrpc_del_service_installe(self,cred_user,id_service=None,id_serveur=None):
        """suppression d'un service"""
        if id_service and id_serveur:
            query = """delete from services_installes where id_serveur = %s and id_service = %s"""
            # on récupère les services de ce serveur
            params = (int(id_serveur), int(id_service))
            return self.dbpool.runOperation(query).addCallbacks(lambda x:(1,'ok'), db_client_failed)
        else:
            # paramètres manquants
            return 0,u("""donnez un id de service et un id de serveur""")

    def xmlrpc_get_service_installe(self,cred_user,id_serveur=None):
        """liste des services installés sur un serveur"""
        if id_serveur:
            query = """select * from services_installes where id_serveur = %s"""
            return self.dbpool.runQuery(query, (int(id_serveur),)).addCallbacks(self._got_service_installe,db_client_failed)
        else :
            query = """select * from services_installes"""
            return self.dbpool.runQuery(query).addCallbacks(self._got_service_installe,db_client_failed)
