# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir testant le résultat de la dernière sauvegarde
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import boolean_to_onoff, status_to_img
from pyeole.bareos import bareos_rapport_load, bareos_rapport_load_pcent_usage, bareos_rapport_load_free_space, \
        BAREOS_RAPPORT_UNKNOWN, BAREOS_RAPPORT_OK, BAREOS_RAPPORT_ERR

class Sauvegarde(Agent):

    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.table = TableData([
            ('status', 'Statut', {'align':'center'}, status_to_img),
            ('type', 'Type de sauvegarde', {'align':'center'}, None),
            ('comment', 'Dernière sauvegarde', {'align':'center'}, None)])
        self.tabledisk = TableData([
            ('status', 'Statut', {'align':'center'}, status_to_img),
            ('type', 'Type', {'align':'center'}, None),
            ('comment', 'Mesure', {'align':'center'}, None)])
        self.tablefreesp = TableData([
            ('status', 'Statut', {'align':'center'}, status_to_img),
            ('type', 'Type', {'align':'center'}, None),
            ('comment', 'Estimation de l’espace disponible', {'align':'center'}, None)])
        self.data = [self.table, self.tabledisk, self.tablefreesp]
        self.status = status.OK()

    def measure(self):
        ret_pre = bareos_rapport_load('cronpre')
        ret_svg = bareos_rapport_load('sauvegarde')
        ret_ctlg = bareos_rapport_load('catalogue')

        pcent, ipcent = bareos_rapport_load_pcent_usage()
        freesp_status, freesp_comment = bareos_rapport_load_free_space()

        status_pre = {BAREOS_RAPPORT_UNKNOWN: status.Unknown(),
                BAREOS_RAPPORT_OK: status.OK(),
                BAREOS_RAPPORT_ERR: status.Error()}.get(ret_pre[0])
        status_svg = {BAREOS_RAPPORT_UNKNOWN: status.Unknown(),
                BAREOS_RAPPORT_OK: status.OK(),
                BAREOS_RAPPORT_ERR: status.Error()}.get(ret_svg[0])
        status_ctlg = {BAREOS_RAPPORT_UNKNOWN: status.Unknown(),
                BAREOS_RAPPORT_OK: status.OK(),
                BAREOS_RAPPORT_ERR: status.Error()}.get(ret_ctlg[0])
        status_frdi = {BAREOS_RAPPORT_UNKNOWN: status.Unknown(),
                BAREOS_RAPPORT_OK: status.OK(),
                BAREOS_RAPPORT_ERR: status.Warn()}.get(freesp_status)

        res = [{ 'status': status_pre,
                 'type': 'préparation',
                 'comment': ret_svg[1]},
               { 'status': status_svg,
                 'type': 'sauvegarde',
                 'comment': ret_svg[1]},
               { 'status': status_ctlg,
                 'type': 'catalogue',
                 'comment': ret_ctlg[1]}]
        #pcent
        if pcent == -1:
            status_pc = status.Unknown()
            dpcent = ''
        elif pcent < 80:
            status_pc = status.OK()
            dpcent = str(pcent) + '%'
        elif pcent < 90:
            status_pc = status.Warn()
            dpcent = str(pcent) + '%'
        else:
            status_pc = status.Error()
            dpcent = str(pcent) + '%'
        resdisk = [{'status': status_pc,
            'type': 'espace utilisé sur le support',
            'comment': dpcent}]
        #ipcent
        if ipcent == -1:
            status_pci = status.Unknown()
            dpcent = ''
        elif ipcent < 80:
            status_pci = status.OK()
            dpcent = str(ipcent) + '%'
        elif ipcent < 90:
            status_pci = status.Warn()
            dpcent = str(ipcent) + '%'
        else:
            status_pci = status.Error()
            dpcent = str(ipcent) + '%'
        resdisk.append({'status': status_pci,
            'type': 'inodes utilisés sur le support',
            'comment': dpcent})

        resfreesp = [{'status': status_frdi,
            'type': 'espace disponible sur le support',
            'comment': freesp_comment}]

        self.status = max(status_pre, status_svg, status_ctlg, status_pc, status_pci, status_frdi)
        return {'statistics': res, 'disk': resdisk, 'free_space': resfreesp}

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['statistics']
            self.tabledisk.table_data = self.last_measure.value['disk']
            self.tablefreesp.table_data = self.last_measure.value['free_space']

    def check_status(self):
        return self.status

