#!/bin/bash
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# maj_client.sh
#
# script de mise à jour du paquet zephir-client
#
###########################################################################

# récupération du dernier rpm sur zephir avec wget
wget --no-check-certificate  https://$1:8090/client/$2 &>/tmp/maj_zephir.log
if [ $? -ne 0 ]
then
	exit 1
fi
# installation du paquet
dpkg -i $2
if [ $? -ne 0 ]
then
	echo "erreur lors de l'installation de $2"
	exit 1
fi
# suppression de la copie du RPM
rm -f $2

# redémarrage de z_stats après la mise à jour si il est lancé
if [ -f /var/run/z_stats.pid ]
then
	service z_stats restart
fi

exit 0
