#!/usr/bin/env python
# -*- coding: UTF-8 -*-
"""Etat de la mémoire
"""

import os, time

from agent import Agent

class MemAgent(Agent):
    """Bilan de l'etat de la memoire
    """
    def __init__(self,exec_cmd="/bin/cat /proc/meminfo"):
        self.exec_cmd = exec_cmd
        self.name = "mem"
        self.description="""Bilan de la mémoire"""
        Agent.__init__(self)
        # écriture dans les fichiers
        self.write_html()
        self.write_xml()

    HTML = """
<div class="titlediv">
<h1 class="newstitle">
Etat de la mémoire 
</h1>
<a name="%s"/>
</div>
<div class="bodydiv">
Variables décrivant l'état mémoire : <br/>
<ul>
<li>mémoire totale : %s</li>
<li>mémoire libre  : %s</li>
</ul>
</div>
"""

    def _cat(self):
        sortie = os.popen(self.exec_cmd)
        resultat = sortie.read()
        sortie.close()
        return resultat.split("\n")

    def _mem(self):
        l = self._cat()
        mem_total = l[3].split(":")[1].strip()
        mem_free = l[4].split(":")[1].strip()
        return mem_total, mem_free

    def _dump_xml(self):
        """Formatage en xml du résultat
        """
        mem_total, mem_free = self._mem()

        MEM_DATA = """
<data nom="etat memoire">
<variable name="mem_total" value="%s"/>
<variable name="mem_libre" value="%s"/>
</data>
"""
        return MEM_DATA % (mem_total, mem_free)

    def _dump_html(self):
        """Formatage html du résultat 
        """
        mem_total, mem_free = self._mem()
        return self.HTML % (self.name, mem_total, mem_free)

if __name__ == "__main__":
    MemAgent()


