# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2021
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent DBCheck
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData, HTMLData
#from twisted.internet.utils import getProcessOutput
from zephir.monitor.agentmanager import status
from os.path import isfile
from zephir.monitor.agentmanager.util import status_to_img
import os

FILENAME='/var/lib/eole/reports/samba-dbcheck.log'


class DBCheck(Agent):
    """
    Utilisateurs connectes
    """
    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.status = status.Unknown()
        self.table = TableData([
            ('status', 'état', {'align':'center'}, status_to_img),
            ('msg', 'message', {'align':'left'}, None)
        ])
        self.data = [self.table]

    def measure(self):
        ret = {}
        if not isfile(FILENAME):
            ret['msg'] = ''
            ret['status'] = ''
        else:
            with open(FILENAME) as fh:
                line = fh.read()
            if not line:
                ret['msg'] = 'Information indisponible'
                ret['status'] = ''
            else:
                try:
                    error_nb = int(line.strip().split()[0])
                    if error_nb > 1:
                        ret['msg'] = f"Nombre d'erreurs détectées : {error_nb}"
                    else:
                        ret['msg'] = f"Nombre d'erreur détectée : {error_nb}"
                    ret['status'] = {0: 'On'}.get(error_nb, 'Off')
                except ValueError as err:
                    ret['msg'] = str(err)
                    ret['status'] = 'Off'
        self.status = {'On': status.OK(), 'Off': status.Error(),
                       '': status.Unknown()}.get(ret['status'])
        return [ret]

    def check_status(self):
        return self.status

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value
