#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""Disk free
"""

import os, commands
from utils import list_to_table
from agent import Agent

class DiskFree(Agent):
    def __init__(self):
        self.name="df"
        self.description="""Occupation des systèmes de fichier"""
        Agent.__init__(self)
        # écriture dans les fichiers
        # self.write_html()
        # self.write_xml()

    HTML = """
<div class="titlediv">
<h1 class="newstitle">%s</h1>
</div>
<div class="bodydiv">
%s
</div>
"""
    def _df(self):
        """Récupère la sortie de df
        """
        # récupération de la sortie de la commande 
        exec_cmd = "df"
        s = commands.getoutput(exec_cmd)
        lignes = s.splitlines()
        df_output = lignes[1:]
        # return df_output
        # les données sont mises dans une liste de dictionnaires
        l = []
        for ligne in df_output:
            d = {}
            partion = ligne.split()
            d["Système de Fichiers"] = partion[0]
            d["Taille"] = partion[1]
            d["Utilisé"] = partion[2]
            d["Disponible"] = partion[3]
            d["Utilisé (Pourcentage)"] = partion[4]
            d["Point de montage"] = partion[5]

            l.append(d)
        return l

    def _dump_xml(self):
        """sortie en xml
        """
        resultat = self._df()
        return list_to_table(resultat)

    def _dump_html(self):
        """Formatage html du résultat 
        """
        return self.HTML % (self.description, self._dump_xml())
    
if __name__ == "__main__":
    disk = DiskFree()
    print str(disk._df())
