# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir pour la surveillance d'expiration des certificats
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import HTMLData, TableData
from zephir.monitor.agentmanager import status, util
from twisted.internet.utils import getProcessOutput
import datetime

class Cert(Agent):
    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        # warning : 45 jours
        self.warn_delay = 45
        # erreur : 30 jours
        self.err_delay = 30
        self.status = status.OK()
        self.table = TableData([
            ('subj', "Sujet du certificat", {'align':'left'}, None),
            ('expire', "Date d'expiration", {'align':'left'}, None),
            ('delay', "Temps restant", {'align':'left'}, None),
            ])
        title = HTMLData("<h3>Surveillance des certificats</h3>")
        self.data = [title, self.table]

    def frozen_ipsec_callback(self, response):
        if response != '':
            cmd = 'echo'
        else:
            cmd = "/usr/sbin/ipsec"
        update = getProcessOutput(cmd, ['listcerts'])
        return update.addCallbacks(self.callback_expire, self.errback_expire)

    def frozen_ipsec_errback(self):
        log.msg("It doesn't work")

    def measure(self):
        self.status = status.OK()
        cmd = "pgrep"
        res = getProcessOutput(cmd, ['stroke'])
        return res.addCallbacks(self.frozen_ipsec_callback, self.frozen_ipsec_errback)

    def callback_expire(self, response):
        # recherche des informations
        data = {}
        subj = ""
        for line in response.decode().strip().split('\n'):
            if line.count('subject:') == 1:
                subj = line.split('subject:')[1].strip()
            if line.count('not after') == 1:
                expires = line.split('not after')[1].strip().split(',')[0].strip()
                expires = " ".join(expires.split()[:4])
                data[subj] = expires
        res = []
        status_err = False
        status_warn = False
        self.measure_data = {}
        for sub, expires in data.items():
            # calcul du temps restant
            expdate = util.parse_date(expires)
            delta = expdate - datetime.datetime.now()
            delay = "{} jour{}".format(delta.days, 's' if delta.days > 1 else '')
            if delta.days < self.err_delay:
                if not status_err:
                    # première erreur détectée
                    err = delta.days
                    status_err = True
                    if err < 0:
                        err_msg = "Au moins un certificat a expiré"
                    else:
                        err_msg = "Fin de validité dans moins de {} jour{}".format(err, 's' if err > 1 else '')
                else:
                    # nouvelle erreur détectée : le message affiche la plus grave
                    if err >= 0 and delta.days < 0:
                        err = delta.days
                        err_msg = "Au moins un certificat a expiré"
                    elif delta.days < err:
                        err_msg = "Fin de validité dans moins de {} jour{}".format(err, 's' if err > 1 else '')
            elif delta.days < self.warn_delay:
                warn = delta.days
                status_warn = True
            res.append({'subj':sub,
                        'expire':str(util.parse_date(expires)),
                        'delay':delay})
            self.measure_data[sub] = delay
        if status_err:
            self.status = status.Error(err_msg)
        elif status_warn:
            self.status = status.Warn("Fin de validité dans moins de %d jours" % warn)
        return res

    def errback_expire(self, err):
        msg = u"erreur de lecture de la date d'expiration"
        self.status = status.Warn(msg)
        return None

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value

    def check_status(self):
        return self.status

