#-*- coding: utf-8 -*-

from configparser import ConfigParser, DEFAULTSECT

class SafeUTF8ConfigParser(ConfigParser):

    def write(self, fp, *args, **kwargs):
        """Write an .ini-format representation of the configuration state."""
        if self._defaults:
            fp.write(f"[{DEFAULTSECT}]\n")
            for (key, value) in self._defaults.items():
                if isinstance(key, bytes):
                    key = key.decode('utf-8')
                if isinstance(value, bytes):
                    value = value.decode('utf-8')
                fp.write("{0} = {1}\n".format(key, value.replace('\n', '\n\t')))
            fp.write("\n")
        for section in self._sections:
            fp.write(f"[{section}]\n")
            for (key, value) in self._sections[section].items():
                if isinstance(key, bytes):
                    key = key.decode('utf-8')
                if isinstance(value, bytes):
                    value = value.decode('utf-8')
                if key == "__name__":
                    continue
                if (value is not None) or (self._optcre == self.OPTCRE):
                    key = " = ".join((key, value.replace('\n', '\n\t')))
                fp.write(f"{key}\n")
            fp.write("\n")
