#!/usr/bin/python3
# -*- coding: UTF-8 -*-

############################################################################
#                                                                          #
#  Utilitaire de configuration controle-vnc                                #
#                                                                          #
#  licence GPL Eole                                                        #
#                                                                          #
#  eole@ac-dijon.fr                                                        #
#                                                                          #
############################################################################

from cfgparse import ConfigParser
from getopt import getopt, GetoptError
from sys import argv, exc_info, exit


class vncOpts:
    def __init__(self):
        self.fich = '/home/workgroups/professeurs/controle-vnc/controle-vnc.ini'

    def typeVue(self):
        try:
            c = ConfigParser()
            c.add_file(self.fich)
            self.typeview = c.add_option('vncviewer').get().lower().strip()
#            return 'vncviewer.exe /viewonly'
#            return self.typeview
            if self.typeview == 'vncviewer.exe /viewonly':
                return 'simple'
            elif self.typeview == 'vncviewer.exe':
                return 'controle'
            else:
                return 'desactive'
        except:
            return None

    def modifVue(self, vue):
        try:
            c = ConfigParser()
            c.add_file(self.fich)
            if vue == 'simple':
                vue = 'vncviewer.exe /viewonly'
                c.add_option('vncviewer').set(vue).write(self.fich)
            elif vue == 'controle':
                vue = 'vncviewer.exe'
                c.add_option('vncviewer').set(vue).write(self.fich)
            elif vue == 'desactive':
                vue = ''
                c.add_option('vncviewer').set(vue).write(self.fich)
            return True
        except:
            return False

def main():
    """
    """
    try:
        options, args = getopt(argv[1:],'v:hl',
        ['vue=',
        'help',
        'liste'])

    except GetoptError:
        er_type, er_value, er_traceback = exc_info()
        er_msg = str(er_value)
        exit("l'option -%s est inconnue ou nécessite un argument" % er_msg.split(' ')[1])

    vnc_opts = vncOpts()
    liste_vues = ['simple', 'controle', 'desactive']
    for (opt,val) in options:
        # quel support
        if (opt == '-v') or (opt == '--vue'):
            vue = val.lower()
            if vue not in liste_vues:
                print('Vue "%s" inconnu'%vue)
                return
            vnc_opts.modifVue(vue)
            print(vnc_opts.typeVue())
        #listing
        elif (opt == '-l') or (opt == '--liste'):
            print(vnc_opts.typeVue())
        else:
            print("""Usage :
%s -l --liste
%s -v VUE --vue VUE (simple, controle, desactive)
"""%(argv[0],argv[0]))

if __name__ == "__main__":
    main()

