# -*- coding: UTF-8 -*-
from os.path import dirname, abspath, join, isdir
from shutil import rmtree
from os import makedirs, stat

import pathvnc
from pyeole.process import system_out
from scribe import login

TEST_DIR = dirname(abspath(__file__))
login.PATH_SCRIPTS = join(TEST_DIR, 'scripts')
login.SMB_SERVEUR = 'test'

def test_get_scripts_list():
    list1 = login.get_scripts_list('cadoles', 'scribe', 'CIFSFS',
            ['eleves', '6eme', '6eme2'])
    list2 = []
    for l in ['/users/cadoles.txt', '/machines/scribe.txt',
            '/groups/eleves.txt', '/os/CIFSFS/eleves.txt', '/groups/6eme.txt',
            '/os/CIFSFS/6eme.txt', '/groups/6eme2.txt', '/os/CIFSFS/6eme2.txt',
            '/os/CIFSFS.txt', '/os/CIFSFS/cadoles.txt']:
        list2.append('%s%s' % (login.PATH_SCRIPTS, l))
    assert list1 == list2

def test_gen_cmd_line():
    ret1 = login.gen_cmd_line('c:\\\\notepad.exe')
    ret2 = 'cmd,c:\\\\notepad.exe\r\n'
    assert ret1 == ret2
    ret1 = login.gen_cmd_line('c:\\\\notepad.exe', True)
    ret2 = 'cmd,c:\\\\notepad.exe,HIDDEN\r\n'
    assert ret1 == ret2
    ret1 = login.gen_cmd_line('c:\\\\notepad.exe', False, True)
    ret2 = 'cmd,c:\\\\notepad.exe,NOWAIT\r\n'
    assert ret1 == ret2
    ret1 = login.gen_cmd_line('c:\\\\notepad.exe', True, True)
    ret2 = 'cmd,c:\\\\notepad.exe,HIDDEN,NOWAIT\r\n'
    assert ret1 == ret2

def test_gen_letter_share():
    ret1 = login.gen_letter_share('c:', '\\\\test\\test')
    ret2 = ('c', '\\\\test\\test')
    assert ret1 == ret2
    ret1 = login.gen_letter_share('c:', '\\\\test\\test\\')
    assert ret1 == ret2
    ret1 = login.gen_letter_share('c', '\\\\test\\test\\')
    assert ret1 == ret2

def test_gen_lecteur_bloc():
    ret1 = login.gen_lecteur_bloc('c:', '\\\\test\\test')
    ret2 = 'lecteur,c:,\\\\test\\test\r\n'
    assert ret1 == ret2
    ret1 = login.gen_lecteur_bloc('c:', '\\\\test\\test\\')
    assert ret1 == ret2
    ret1 = login.gen_lecteur_bloc('c', '\\\\test\\test\\')
    assert ret1 == ret2

def test_parse_line():
    #lecteur
    ret1 = login.parse_line('CIFSFS', 'lecteur,c,\\\\test\\test')
    ret2 = 'lecteur,c:,\\\\test\\test\r\n'
    assert ret1 == ret2

    #cmd
    ret1 = login.parse_line('CIFSFS', 'cmd,c:\\\\notepad.exe')
    ret2 = 'cmd,c:\\\\notepad.exe\r\n'
    assert ret1 == ret2
    ret1 = login.parse_line('CIFSFS', 'cmd,c:\\\\notepad.exe,HIDDEN')
    ret2 = 'cmd,c:\\\\notepad.exe,HIDDEN\r\n'
    assert ret1 == ret2
    ret1 = login.parse_line('CIFSFS', 'cmd,c:\\\\notepad.exe,NOWAIT')
    ret2 = 'cmd,c:\\\\notepad.exe,NOWAIT\r\n'
    assert ret1 == ret2
    ret1 = login.parse_line('CIFSFS', 'cmd,c:\\\\notepad.exe,HIDDEN,NOWAIT')
    ret2 = 'cmd,c:\\\\notepad.exe,HIDDEN,NOWAIT\r\n'
    assert ret1 == ret2
    ret1 = login.parse_line('CIFSFS', 'cmd,c:\\\\notepad.exe,ERROR')
    ret2 = 'cmd,c:\\\\notepad.exe\r\n'
    assert ret1 == ret2

    #error
    ret1 = login.parse_line('CIFSFS', 'error,c,\\\\test\\test')
    ret2 = ''
    assert ret1 == ret2

def test_get_scripts():
    ret1 = login.get_scripts('cadoles', 'scribe', 'CIFSFS',
            ['eleves', '6eme', '6eme2'])
    ret2 = ('lecteur,c:,\\\\test\\test\r\n',
            'cmd,c:\\\\notepad.exe,NOWAIT\r\n')
    assert ret1 == ret2

def test_write_fich():
    tmp_dir = join(TEST_DIR, 'tmp')
    tmp_file = join(tmp_dir, 'script.txt')
    if isdir(tmp_dir):
        rmtree(tmp_dir)
    makedirs(tmp_dir)
    content = 'IF EXIST c:\\nul goto errctest\r\nNET USE  c: \\\\test\\test\r\ngoto suitctest\r\n:errctest\r\nNET USE  * \\\\test\\test\r\n:suitctest\r\nc:\\\\notepad.exe\r\n'
    login.write_fich(tmp_file, content)
    assert open(tmp_file, 'r').read() == content
    # tester les permissions
    assert stat(tmp_file).st_mode == 33188
    assert stat(tmp_file).st_uid == 0
    assert stat(tmp_file).st_gid == 0

def test_gen_fich():
    tmp_dir = join(TEST_DIR, 'tmp')
    tmp_file = join(tmp_dir, 'script.txt')
    if isdir(tmp_dir):
        rmtree(tmp_dir)
    makedirs(tmp_dir)
    user = 'cadoles'
    groups = ['eleves', '6eme', '6eme2']
    shares = [{'drive': '', 'uri': '\\\\test\\test'},
            {'drive': 'd:', 'uri': '\\\\test\\test2'},
            {'drive': 'e', 'uri': '\\\\test\\test3'},
            {'drive': 'f', 'uri': '\\\\test\\test4\\'}]
    machine = 'scribe'
    ostype = 'CIFSFS'
    homedrive = 'u:'
    userclass = 'eleve'
    netlogon = tmp_file
    login.gen_fich(user, groups, shares, machine, ostype, homedrive,
            userclass, netlogon)
    content = 'lecteur,c:,\\\\test\\test\r\nlecteur,d:,\\\\test\\test2\r\nlecteur,e:,\\\\test\\test3\r\nlecteur,f:,\\\\test\\test4\r\ncmd,c:\\\\notepad.exe,NOWAIT\r\n'
    assert open(tmp_file, 'r').read() == content
    userclass = 'enseignant'
    login.gen_fich(user, groups, shares, machine, ostype, homedrive,
            userclass, netlogon)
    assert open(tmp_file, 'r').read() == content
    userclass = 'administratif'
    login.gen_fich(user, groups, shares, machine, ostype, homedrive,
            userclass, netlogon)
    assert open(tmp_file, 'r').read() == content
