# -*- coding: UTF-8 -*-
"eole-sso authenticate server tests"
# **IMPORTANT** please set UNITTESTS_MODE = True in sso/authserver.py
# to make the test pass
import autopath
from os.path import dirname, abspath, join, normpath
from sso.authserver import *

HERE = dirname(abspath(__file__))
DATA = normpath(join(HERE, 'data'))
app_filters_path = join(DATA, 'app_filters')

def setup_module(module):
    module.manager = SSOSessionManager()

def test_initcaches():
    # this test isn't so much to test that the cache *works*
    # -- it's more to test that it's *there*
    assert manager.login_sessions.timeout == 180
    assert manager.saml_sent_msg.maxlen == 500
    assert manager.relay_state_cache.maxlen == 500
    assert manager.saml_rcved_msg.maxlen == 200

def test_filters():
    apps = []
    filters = []
    for conf_file in glob('%s/*.ini' % app_filters_path):
        conf_filename = os.path.splitext(os.path.basename(conf_file))[0]
        cfg = EoleParser()
        cfg.read(conf_file)
        if conf_filename.endswith('_apps') or conf_filename == 'applications':
            # liste des applications associées aux filtres
            new_apps, new_filters = manager.load_applications(cfg)
            apps.extend(new_apps)
            filters.extend(new_filters)
    expected_apps = set(['default_saml', 'ead2', 'eole_openid'])
    expected_filters = set(['saml', 'ead2', 'openid'])
    assert set(apps) == expected_apps
    assert set(filters) == expected_filters

