# -*- coding: UTF-8 -*-
"eole-sso ticket tests"
import autopath
from py.test import raises

from ticketcache import *

#class pgt_url:
#    def geturl(self):   
#        return "http://pgturl:7777"

class TestAppTicketCache:
    def setup_method(self, method):
        self.service = 'https://192.168.230.155:8443/'
        self.app_ticket = TicketCache(1200, self.service)
        self.app_ticket2 = TicketCache(1200, self.service)

    def test_initialize(self):
        # this test isn't so much to test that the ticket cache *works*
        # -- it's more to test that it's *there*

        assert self.app_ticket.timeout == 1200
        assert self.app_ticket2.timeout == 1200
        # default ticket prefix
        assert self.app_ticket.prefix == "LT" 

    def test_gen_ticket_id(self):
        assert "LT-" + self.service in self.app_ticket.gen_ticket_id()
    
    def test_add_session_get_session(self):
        session_id = self.app_ticket.add_session("session_data")
        assert "LT-" + self.service in session_id
        assert session_id in self.app_ticket.ticket_cache
        assert self.app_ticket.ticket_cache[session_id][1] == "session_data"
        assert self.app_ticket.get_session_info(session_id) == "session_data"
        raises (InvalidSession, "self.app_ticket.get_session_info('eggs')")
        # no renew
        assert session_id not in self.app_ticket.ticket_cache        

    def test_add_session_validate_session(self):
        session_id = self.app_ticket.add_session("session_data")
        assert "LT-" + self.service in session_id
        assert session_id in self.app_ticket.ticket_cache
        assert self.app_ticket.ticket_cache[session_id][1] == "session_data"
        assert session_id in self.app_ticket.ticket_cache        
        assert self.app_ticket.validate_session(session_id) == True    
        assert self.app_ticket.validate_session("egg") == False

class TestSamlMsgCache:

    def setup_method(self, method):
        self.saml_cache = SamlMsgCache(1200)
        self.saml_cache2 = SamlMsgCache(2)    
        self.saml_cache2.add(1, 'data1')
        self.saml_cache2.add(2, 'data2')        
        
    def test_initialize(self):
        # this test isn't so much to test that the saml cache *works*
        # -- it's more to test that it's *there*
        self.saml_cache.maxlen == 1200
        assert len(self.saml_cache) <= self.saml_cache.maxlen
            
    def test_add_get_msg(self):
        self.saml_cache.add(123, 'data')
        assert self.saml_cache[123] == 'data'
        assert self.saml_cache.get_msg(123) == 'data'
        assert self.saml_cache.get_msg(456) == None
        assert len(self.saml_cache2) == self.saml_cache2.maxlen
        self.saml_cache2.add(3, 'data3')        
        self.saml_cache2.add(4, 'data4')
        assert self.saml_cache2.get_msg(4) == 'data4'
   
