# -*- coding: UTF-8 -*-
"eole-sso ticket tests"
import autopath

from ticket import *

class pgt_url:
    def geturl(self):   
        return "http://pgturl:7777"

class TestAppTicket:
    def setup_method(self, method):
        self.service = 'https://192.168.230.155:8443/'
        self.app_ticket = AppTicket('ticket', 'session_id', self.service, 
                                    'http://casserver:8080')
        self.app_ticket2 = AppTicket('ticket', 'session_id', self.service, 
                                    'http://casserver:8080')

        self.urltest = "https://192.168.230.155:8443/?" + \
                       "service=https://192.168.230.165/webshare"
        self.fakepgt_url = pgt_url()
    
    def test_initialize(self):
        "this test is much more to test that the ticket is here"
        assert self.app_ticket.ticket == 'ticket'

    def test_generate_pgt(self):
        "app_ticket has a pgt attriute"
        self.app_ticket.generate_pgt(self.fakepgt_url)
        assert 'PGT' in self.app_ticket.pgt 
        assert 'PGTIOU-http://casserver:8080-' in self.app_ticket.pgtiou
        assert self.app_ticket.pgt_url == "http://pgturl:7777"
        # reset 
        self.app_ticket.reset_pgt()
        assert self.app_ticket.pgt_url == None
        assert self.app_ticket.pgt == None
        assert self.app_ticket.pgtiou == None
        
    def test_verif_ticket(self):
        # the ticket is valid
        assert self.app_ticket.verif_ticket('ticket', self.urltest) == True
        # the ticket is valid, the second validation call must be False anyway
        assert self.app_ticket.verif_ticket('ticket', self.urltest) == False
        # let's have a brand new object
        assert self.app_ticket2.verif_ticket('ticket', self.urltest) == True        
        self.app_ticket2.valid = False
        assert self.app_ticket2.verif_ticket('ticket', self.urltest) == False        

    def test_proxypath(self):
        assert self.app_ticket.proxypath() == []
        self.app_ticket.generate_pgt(self.fakepgt_url)
        assert self.app_ticket.pgt_url == 'http://pgturl:7777'
        assert self.app_ticket.proxypath() == []
        self.app_ticket2.generate_pgt(self.fakepgt_url)
        self.app_ticket.parent = self.app_ticket2
        assert self.app_ticket.proxypath() == ['http://pgturl:7777']
        
