# -*- coding: utf8 -*-
# Cree par PR  - DSI SRSI - Academie Aix-Marseille 06/2019

""" On récupère l'uid, le title et le FrEduRNE sur le LDAP Agent
"""
from eoleaaf.config import ldap_agent_server, ldap_agent_user_dn, ldap_agent_user_password, ldap_agent_base_dn

import ldap

class AgentLDAP:
    def __init__(self):
        if ldap_agent_server:
            self.connexion = ldap.open(ldap_agent_server)
            self.connexion.simple_bind_s(ldap_agent_user_dn, ldap_agent_user_password)
        else:
            self.connexion = None

    def unbind(self):
        if self.connexion:
            self.connexion.unbind_s()

    def find_ldap_agent(self, mail):
        if not self.connexion:
            return None
        results = self.connexion.search_s(ldap_agent_base_dn, ldap.SCOPE_SUBTREE, f'(mail={mail})', ['uid', 'title'])
        if len(results) != 1:
            return None
        uid = results[0][1].get('uid', [''])[0]
        title = results[0][1].get('title', [''])[0]
        return (uid, title)


