. /usr/lib/eole/ihm.sh

len_pf=26

Inactif() {
printf ".  %${len_pf}s => " "$1"
EchoOrange "Désactivé"
}

NoConfig() {
printf ".  %${len_pf}s => " "$1"
EchoOrange "Non configuré"
}

TestIP() {
len=$((len_pf-7))
printf "%-9s %${len}s => " "$2:" "$1"
/usr/bin/fping -t50 -r2 $1 > /dev/null 2>&1
if [ $? -eq 0 ]
then
   EchoVert "Ok"
else
   EchoRouge "Erreur"
fi
}

TestIP2() {
# présentation normale ;)
printf ".  %${len_pf}s => " "$2"
/usr/bin/fping -t50 -r2 $1 > /dev/null 2>&1
if [ $? -eq 0 ]
then
   EchoVert "Ok"
else
   EchoRouge "Erreur"
fi
}

TestARP() {
    if [ -z "$3" ]; then
        # recherche de l'interface reseau + test
        interface=`ip route get $1 2> /dev/null|sed -ne '/ via /! s/^.* dev \([^ ]\+\) \+src \+.*$/\\1/p;Q'`
        [ "$interface" = "" ] && EchoRouge " Erreur interne impossible de determiner l'interface"
        /sbin/ifconfig $interface > /dev/null 2>&1
        [ ! $? = 0 ] && EchoRouge " Erreur interne impossible de determiner l'interface"
    else
        interface=$3
    fi

    # utilisation d'arping
    printf ".  %${len_pf}s => " "$2"
    /usr/bin/arping -w 1 -c 1 -f $1 -I $interface > /dev/null 2>&1
    if [ $? -eq 0 ]
    then
       EchoVert "Ok"
    else
       EchoRouge "Erreur"
    fi
}

TestService() {
printf ".  %${len_pf}s => " "$1"
CMD="/usr/bin/tcpcheck 2 $2 2> /dev/null | grep -q \" alive\""
if [ ! "$3" = "" ]; then
    CreoleRun "$CMD" "$3"
    ret=$?
else
    CreoleRun "$CMD"
    ret=$?
fi
if [ $ret -eq 0 ]
then
   EchoVert "Ok"
   return 0
else
   EchoRouge "Erreur"
   return 1
fi
}

TestUDP() {
printf ".  %${len_pf}s => " "$1"
CMD="netstat -unl | grep -q \":$2 \""
if [ ! "$3" = "" ]; then
    CreoleRun "$CMD" "$3"
    ret=$?
else
    CreoleRun "$CMD"
    ret=$?
fi
if [ $ret -eq 0 ]
then
   EchoVert "Ok"
   return 0
else
   EchoRouge "Erreur"
   return 1
fi
}

TestPid() {
printf ".  %${len_pf}s => " "$1"
pidof "$2" > /dev/null
if [ $? -eq 0 ];then
    EchoVert "Ok"
    return 0
else
    EchoRouge "Erreur"
    return 1
fi
}

TestDns() {
printf ".  %${len_pf}s => " "DNS $1"
/usr/bin/host -W2 -tA $2 $1 > /dev/null 2>&1
if [ $? -eq 0 ];then
    EchoVert "Ok"
    return 0
else
    EchoRouge "Erreur"
    return 1
fi
}

TestNTP() {
printf ".  %${len_pf}s => " "Statut NTP"
/usr/bin/ntpstat > /dev/null 2>&1
if [ $? -eq 0 ]
then
   EchoVert "Synchronisé"
elif [ $? -eq 1 ]
then
   EchoRouge "Désynchronisé"
   for ntp in $1;do
       printf ".  %${len_pf}s => " "NTP $ntp"
       /usr/sbin/ntpdate -q $ntp > /dev/null 2>&1
       if [ $? -eq 0 ]; then
           EchoVert "Ok"
       else
           EchoRouge "Erreur"
       fi
   done
else
   EchoRouge "Erreur"
fi
}

TestHTTPPage() {
printf ".  %${len_pf}s => " "$1"
/usr/bin/httping -g $2 -c 1 > /dev/null 2>&1
if [ $? -eq 0 ]
then
   EchoVert "Ok"
else
   EchoRouge "Erreur"
fi
}

TestHTTPService() {
# Test HTTP code is OK
printf ".  %${len_pf}s => " "$1"
/usr/bin/wget -t2  --connect-timeout=3 --delete-after -nv $2  > /dev/null 2>&1
if [ $? -eq 0 ]
then
   EchoVert "Ok"
else
   EchoRouge "Erreur"
fi
}

TestWeb() {
WGET_OPTIONS="-t2  --connect-timeout=3 --delete-after"
WARN_MSG=""
PROXIES_TESTS="PROXY:"
if [ "$(CreoleGet activer_proxy_client)" == "oui" ]
then
    PROXIES_TESTS="PROXY:http://$(CreoleGet proxy_client_adresse):$(CreoleGet proxy_client_port)"
fi

for PROXY_LOOP in $PROXIES_TESTS
do
    PROXY=$(echo $PROXY_LOOP | sed -e 's/^PROXY://')
    export http_proxy=$PROXY
    if [ -n "$PROXY" ]
    then
        Proxy=` echo $http_proxy | sed -e 's!http://!!' `
        TestService "Serveur Proxy" $Proxy
        if [ $? -ne 0 ]
        then
            #EchoRouge "Erreur"
            #return 1
            export http_proxy=
        fi
    fi
    # Test 1er site
    wget -q $WGET_OPTIONS $2
    if [ $? -eq 0 ]
    then
        printf ".  %${len_pf}s => " "$1"
        EchoVert "Ok"
        return 0
    fi
    if [ "$3" != "" ]
    then
        # Test second site
        msg=$(wget -nv $WGET_OPTIONS $3 2>&1)
        ret=$?
        if [ $ret -eq 0 ]
        then
            printf ".  %${len_pf}s => " "$1"
            EchoVert "Ok"
            return 0
        elif [ $ret -eq 8 ]
        then
            WARN_MSG="$msg"
        fi
    fi
done

printf ".  %${len_pf}s => " "$1"
if [ -n "$WARN_MSG" ]
then
    EchoOrange "$WARN_MSG"
else
    EchoRouge "Erreur"
fi
return 1
}

# DEPRECATED. Use pyeole/diagnose/certificate.py instead
TestCerts() {
    CERTFILE=$1

    # CODEERROR and MESSAGE not used now
    # ref #22341
    #CODEERROR=$2
    #man verify for CODEERROR
    #MESSAGE=$3
    #

    if [ -z "$4" ]; then
        echo "$CERTFILE" | grep -q '^/etc/ipsec.d/'
        [ $? = 0 ] && CAFILE=/etc/ipsec.d/cacerts/CertifCa.pem || CAFILE=/etc/ssl/certs/ca.crt
    else
        # Fichier de CA spécifié, on désactive l'utilisation
        # des autres autorités installées sur le système.
        CAFILE=$4
    fi
    FAKE_CAPATH="/usr/lib/ssl/no_certs"
    TMPFILE=$(mktemp)
    mkdir -p "$FAKE_CAPATH"
    if [[ -d ${CAFILE}  ]]
    then
        cat ${CAFILE}/* > ${TMPFILE}
        CAFILE=${TMPFILE}
    fi
    ssl_cmd="/usr/bin/openssl verify -CAfile $CAFILE -CApath $FAKE_CAPATH -purpose any $CERTFILE"
    printf ".  %${len_pf}s => " `basename $CERTFILE`
    if [ -e $CAFILE ]; then
        if [ -e $CERTFILE ]; then
            if [ ! -s $CAFILE ] || [ ! -s $CERTFILE ]; then
                EchoRouge "fichier vide"
            else
                sslmsg="`$ssl_cmd 2>&1`"
                ERR_MSG=$(printf "$sslmsg" |grep "^error [0-9]* at ")
                RETCODE=$?
                # supression du répertoire temporaire
                rm -rf "$FAKE_CAPATH"
                if [ $RETCODE -eq 0 ]; then
                    #EchoRouge "Erreur openssl"
                    ERR_MSG=$(cut -d':' -f2 <<< $ERR_MSG)
                    EchoRouge "Erreur : $ERR_MSG"
                    return 1
                else
                    EchoVert "Ok"
                    dns=$(openssl x509 -in $CERTFILE -noout -text \
                        | sed -n -e '/X509v3 Subject Alternative Name/{n;p;}' \
                        | sed -e 's/^ *//' -e 's/DNS://g' -e 's/,//g' \
                              -e 's/IP Address:[0-9]\+\.[0-9]\+\.[0-9]\+\.[0-9]\+//g')
                    if [ ! -z "$dns" ]; then
                        printf ".  %${len_pf}s => " "DNS reconnus"
                        echo $dns
                    fi
                    return 0
                fi
            fi
        else
            EchoRouge "$CERTFILE inexistant"
        fi
    else
        EchoRouge "$CAFILE inexistant"
    fi
}

TestConnexion() {
    connexions=( `/bin/netstat -a --$2 -p -n | grep $1 | grep $3` )
    retour=1
    if [ "$2" = "tcp" ]; then
        sens=$4

        if [ "$sens" = "reception" ]; then
            pos=3
            incr=2
            cond='LISTEN'
        elif [ "$sens" = "envoi" ]; then
            pos=4
            incr=1
            cond='ESTABLISHED'
        fi
        for indice in `seq $pos 7 ${#connexions[*]}`; do
            if [[ ${connexions[$indice]} == *$3* ]]; then
                if [[ ${connexions[$(( $indice + $incr ))]} == $cond ]]; then
                    retour=0
                fi
            fi
        done

    elif [ "$2" = "udp" ]; then
        if [ ${#connexions[*]} -gt 1 ]; then
            retour=0
        fi
    fi

    if [[ $retour == 0 ]]; then
        return 0
    else
        return 1
    fi
}


#
# @NAME : TestMailQ
# @AIM  : Tester si la file d'attente du mailer a des messages "frozen"
# @PARAMS : None
#
function TestMailQ()
{
    ckqueue="exiqgrep -i"
    # Nombre de messages "Frozen"
    printf ".  %${len_pf}s => " "File d'attente"
    mailq=$(CreoleRun "${ckqueue} 2>&1 | wc -l" mail)
    if [[ ${mailq} -eq 0 ]]
    then
        EchoVert "0 message"
    else
        EchoOrange "${mailq} message(s)"
    fi

    frozen="exiqgrep -z -i"
    # Nombre de messages "Frozen"
    printf ".  %${len_pf}s => " "Messages \"Frozen\""
    mailfrz=$(CreoleRun "${frozen} 2>&1 | wc -l" mail)
    if [[ ${mailfrz} -eq 0 ]]
    then
        EchoVert "0 message"
    else
        EchoOrange "${mailfrz} message(s)"
    fi
}
