# -*- coding: UTF-8 -*-

# xml_rpc
from twisted.web import xmlrpc

from twisted.python import log
log.FileLogObserver.timeFormat = "%Y/%m/%d %H:%M:%S %Z"

from scribe.eoleldap import Ldap
from scribe.linker import _user_factory

from fichier.passwd import check_nb_min_classes
from config import debug

class RpcServer(xmlrpc.XMLRPC):
    def __init__(self, secret_key):
        """Prend la clé secrète en paramètre
        """
        xmlrpc.XMLRPC.__init__(self)
        self.secret_key = secret_key

    def verif_cle(self, cle):
        """Vérifie une clé en la comparant à celle dans config
        """
        return str(cle) == self.secret_key

    def xmlrpc_remote_check_nb_min_classes(self, cle, password, nb_classe_min):
        """Teste si le password contient bien nb_classe_min de classe de caractères
        """
        if not self.verif_cle(cle) :
            log.msg('Clé erronnée : %s'%cle)
            return []

        if debug:
            log.msg('Appel de la fonction xmlrpc_remote_check_nb_min_classes')

        return check_nb_min_classes(password, nb_classe_min)

    def xmlrpc_remote_check_password(self, cle, username, password):
        """Teste si le password correspond bien
        """
        if not self.verif_cle(cle) :
            log.msg('Clé erronnée : %s'%cle)
            return False

        if debug:
            log.msg('Appel de la fonction xmlrpc_remote_check_password pour %s' % username)

        conn = Ldap()
        conn.connect()
        ldapuser = _user_factory(username, conn.connexion)

        return ldapuser.auth(username, password)

    def xmlrpc_remote_change_mdp(self, cle, username, old_password, new_password):
        """Change le mot de passe de username en vérifiant son ancien mdp
        """
        if not self.verif_cle(cle) :
            log.msg('Clé erronnée : %s'%cle)
            return False

        if debug:
            log.msg('Appel de la fonction xmlrpc_remote_change_mdp')

        conn = Ldap()
        conn.connect()
        ldapuser = _user_factory(username, conn.connexion)

        # si un prof change son mdp, il doit connaitre le précédent
        if not ldapuser.auth(username, old_password):
            return False

        # application du changement de mot de passe
        ldapuser.c_mod_password(username, new_password, container=None)
        conn.close()
        return True

