#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import optparse, sys, os, subprocess
from IPy import IP

from twisted.internet import defer, threads, reactor


def get_ip_range(ip_start, ip_end, netmask):
    network = IP('%s/%s'%(ip_start, netmask), make_net=True)
    ip_range = []
    ok = False
    for j in network:
        i = j.strNormal()
        if i == ip_start:
            ok = True
        if ok:
            ip_range.append(i)
        if i == ip_end:
            break
    return ip_range

def test_ip(ip):
    c = "tcpcheck 1 %s:8788 | grep -qi alive"%ip
    return execute_cmd(c) == 0

def execute_cmd(cmd):
    return subprocess.call(cmd, shell=True)

def execute_cmd_on_ip(ip, cmd, hide):
    if not test_ip(ip): return
    if hide :
        c = "/usr/share/eole/controlevnc/cliscribe.py %s -execute '%s' HIDE &>/dev/null"%(ip, cmd)
    else:
        c = "/usr/share/eole/controlevnc/cliscribe.py %s -execute '%s' &>/dev/null"%(ip, cmd)
    return execute_cmd(c)

def execute_on_range(ip_start, ip_end, netmask, cmd, hide=False):
    defered_l = []
    for ip in get_ip_range(ip_start, ip_end, netmask):
        d = threads.deferToThread(execute_cmd_on_ip, ip, cmd, hide)
        d.addCallback(return_cmd)
        defered_l.append(d)
    d = defer.DeferredList(defered_l, consumeErrors=True)
    d.addCallback(ret_list)
    return d

def ret_list(r):
    success = 0
    failed = 0
    for i in r:
        if i[1] == 0:
            success += 1
#        else:
#            failed += 1
    return success, failed

def return_cmd(r):
    #TODO
    return r

def retour_exec_range_err(r):
    print 'Range Err', r.getBriefTraceback()
    reactor.stop()

def retour_exec_range(r, cmd):
    success, failed = r
    if success > 1:
        msg = 'La commande "%s" a été exécutée sur %s stations clientes'
    else:
        msg = 'La commande "%s" a été exécutée sur %s station cliente'
    print msg%(cmd, success)
    if failed == 1:
        print '1 échec'
    elif failed > 1:
        print failed, 'échecs'
    reactor.stop()

def myhelp():
    msg = u"""
Exécute une commande dans l'environnement BUILTIN\SYSTEM
sur les clients Windows (2000 et supérieurs) sur une plage d'adresse IP.

%(p)s <adresse_IP_debut_plage> <adresse_IP_fin_plage> <netmask_plage> <cmd> HIDE (optionnel)

Exemple :
%(p)s 172.16.0.20 172.16.0.190 255.255.255.0 "\\\\scribe\\netlogon\\scritpts\\monscript.bat" """%{'p': os.path.basename(sys.argv[0])}
    return msg

def parse_cmdline():
    parser = optparse.OptionParser(myhelp(), version = "%prog")
    (options, args) = parser.parse_args()
    if not 3 < len(args) < 6 :
        parser.error("Nombre d'arguments incorrect !")
    return options, args

def main():
    options, args = parse_cmdline()
    ip_start, ip_end, netmask, cmd  = args[0:4]
    hide = False
    if len(args) == 5:
        if args[4].lower() == 'hide':
            hide = True
    d = execute_on_range(ip_start, ip_end, netmask, cmd, hide)
    d.addCallback(retour_exec_range, cmd)
    d.addErrback(retour_exec_range_err)
    reactor.run()

if __name__ == '__main__':
    main()
