# -*- coding: UTF-8 -*-
"""
Récupération du SID des utilisateurs
La fonction "get_ad_sid" est librement inspiré de :
http://l3rady.com/blog/2009/09/15/php-get-users-sid-from-active-directory-via-ldap-objectsid/
"""
# import globaux
import ldap
import textwrap
# imports locaux
import config

def hex2dec(hexa):
    """
    Transforme une chaîne représentant un nombre
    en hexadécimale en décimale
    """
    return str(int(hexa, 16))

def get_ad_sid(user, rdn, server, aduser, pwdfile):
    """
    Récupération du SID d'un utilisateur depuis
    le serveur AD distant
    #get_ad_sid('prof', 'DC=domaine,DC=lan', '1.1.1.1',
    #           'Administrateur', '/tmp/pwd')
    """
    aduser = "CN={0},CN=Users,{1}".format(aduser, rdn)
    adpwd = file(pwdfile).read().strip()
    # OPT_REFERRALS=0 is mandatory for AD
    ldap.set_option(ldap.OPT_REFERRALS, 0)
    if config.ad_ldaps == "oui":
        ldap.set_option(ldap.OPT_X_TLS_REQUIRE_CERT, ldap.OPT_X_TLS_NEVER)
        connexion = ldap.initialize('ldaps://'+server)
    else:
        connexion = ldap.initialize('ldap://'+server)
    connexion.simple_bind_s(aduser, adpwd)
    res = connexion.search(rdn, ldap.SCOPE_SUBTREE,
                           '(samaccountname={0})'.format(user),
                           ['objectsid'])
    objectsid = connexion.result(res, 60)[1][0][1]['objectSid'][0]
    # Convert Bin to Hex
    hexasid = []
    for binary in objectsid:
        hexasid.extend(textwrap.wrap("%02x" % ord(binary)))
    sid = ['S']
    # Byte 0 = Revision Level
    sid.append(hex2dec(hexasid[0]))
    # Byte 1-7 = 48 Bit Authority
    sid.append(hex2dec(''.join([hexasid[n] for n in range(6, 0, -1)])))
    # Byte 8 count of sub authorities – Get number of sub-authorities
    subauths = hex2dec(hexasid[7])
    # Loop through Sub Authorities
    for i in range(0, int(subauths)):
        start = 8 + 4*i
        # X amount of 32Bit (4 Byte) Sub Authorities
        sid.append(hex2dec(''.join([hexasid[n] for n in range(start+3, start-1, -1)])))
    return '-'.join(sid)

def get_sid(user):
    """
    Renvoie le SID Ldap ou AD
    d'un utilisateur
    """
    from twisted.python import log
    usersid = get_ad_sid(user, config.ad_base, config.ad_address,
                      config.ad_user, config.ad_pwdfile)
    log.msg("from AD : %s"%usersid)
    return usersid
