# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# gest_sessions.py
#
# Librairie pour la gestion des clients Windows
#
###########################################################################

import sys
from os.path import join, isfile
from twisted.python import log
sys.path.append('/usr/share/eole/controlevnc')
import config
from cliscribe import Cliscribe
from esu import ESU
from connexions import Connexions

class Logon:

    def __init__(self):
        """Gestion d'ouverture de session sur les postes clients
        - gestion VNC
        """

    def logon(self, ip, os_type, blocage):
        self.ip, self.blocage = ip, blocage
        self.user, sid, userlname, groups, ost, netbios = \
                Connexions().get_infos(self.ip, os_type)
        logon_dict = ESU(ip, self.user, userlname, groups, sid, ost, netbios)._esu_dict
        if not logon_dict:
            log.err('Machine non geree par Esu')
            return ('Err', u'Machine non gérée par Esu')
        try:
            d = Cliscribe(self.ip).logon(logon_dict=logon_dict)
        except Exception, e:
            log.err(e)
            return ('Err', unicode(e.args[0], 'utf-8', 'replace'))
        if not logon_dict['esu_dict']['ESU_GU']:
            d.addCallback(lambda ret: ('Err', u'Utilisateur non géré par Esu'))
            return d
#        d.addErrback(self.apply_blocage)
        d.addCallback(self.apply_blocage)
#        d.addErrback(self.vnc)
        d.addCallback(self.vnc)
        return d

    def apply_blocage(self, e=False):
#        log.msg('Blocage %s'%e)
#        log.msg('%s %s'%esu.get_drives_type(self))
        return self.blocage.apply_from_user(self.user, self.ip, logon=True)

    def get_vnc_mode(self):
        """récupère le type de controle défini dans l'EAD
        simple, controle, desactive
        """
        vncfile = join(config.vareole, 'controlevnc.conf')
        if isfile(join(vncfile)):
            typecontrole = file(vncfile).readlines()[0].strip()
        else:
            typecontrole = 'simple'
        return typecontrole

    def vnc(self, e=False):
        """renseigne l'activation du clavier pour VNC (en fonction du type d'observation EAD)
        active le type de controle sur la station (lu par gestion-postes.exe)
        """
#        log.msg('Vnc %s'%e)
        mode = self.get_vnc_mode()
        if mode == 'desactive':
            return Cliscribe(self.ip).vnc(action='set_type', value=mode)
        else:
            d = Cliscribe(self.ip).vnc(action='setinputs', value=None, restart=False)
            return d.addCallback(Cliscribe(self.ip).vnc, action='set_type', value=mode)

