# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
# modifié par Cadoles 2012
#
# connectes.py
#
# Librairie de gestion des connectés
#
###########################################################################

#import MySQLdb
import sys, os, time, glob, re
sys.path.append('/usr/share/eole/controlevnc')

from scribe.login import Ldap  # , log_connexion_db
from scribe.ldapconf import USER_FILTER
from pyeole.diagnose import test_tcp
from config import mysql_password, mysql_host, master_ip, activer_ad
import sid as adsid

tdb_file = '/var/run/samba/smbXsrv_session_global.tdb'
separator = '\x00'
PROC_TCP = "/proc/net/tcp"

def remove_duplicated_user_for_ip(sockets):
    last_users = {}
    def _get_timestamp_of_inode(inode):
        '''
        To retrieve the process's creation timestamp, check every running process and look for one using
        the given inode.
        '''
        for item in glob.glob('/proc/[0-9]*/fd/[0-9]*'):
            try:
                if re.search(inode, os.readlink(item)):
                    return os.stat(os.path.dirname(item)).st_ctime
            except:
                pass

    def _hex2dec(s):
        return str(int(s,16))

    def _ip(s):
        ip = [(_hex2dec(s[6:8])),(_hex2dec(s[4:6])),(_hex2dec(s[2:4])),(_hex2dec(s[0:2]))]
        return '.'.join(ip)

    def _convert_ip_port(array):
        host,port = array.split(':')
        return 'ipv4:'+_ip(host)+':'+_hex2dec(port)

    with open(PROC_TCP,'r') as f:
        all_connexions = f.readlines()
        all_connexions.pop(0)

    duplicated = {}
    for ip, lst in sockets.items():
        if len(lst) != 1:
            for ls in lst:
                duplicated[ls[0]] = (ip, ls[1])
        else:
            last_users[ip] = (lst[0][1], ip)

    if duplicated != {}:
        _last_users = {}
        for line in all_connexions:
            line_array = [x for x in line.split(' ') if x !='']    # Split lines and remove empty spaces.
            comp_socket =  _convert_ip_port(line_array[2])
            # only ESTABLISHMENT and corresponding socket
            if line_array[3] == '01' and comp_socket in duplicated.keys():
                timestamp = _get_timestamp_of_inode(line_array[9])
                ip, username = duplicated[comp_socket]
                # si l'ip n'a pas encore été traité ou si l'ip est traité mais avec une date plus ancienne
                # c'est le nouveau username qui est associé à l'IP
                if ip not in _last_users or _last_users[ip][2] < timestamp:
                    _last_users[ip] = (username, ip, timestamp)
        for ip, _last_user in _last_users.items():
            last_users[ip] = (_last_user[0], _last_user[1])

    return last_users.values()

class ComputerNameError(Exception):
    pass


class Session:
    def __init__(self, only=None):
        """lit le contenu de sessionid.tdb
        only: get session information only for one IP
        """
        cnt = 0
        max_cnt = 10
        for cnt in range(max_cnt):
            try:
                self._init_sessions(only)
                break
            except:
                TDB_HANDLER.reopen()
                if cnt == max_cnt-1:
                    # pour voir ce qui plante
                    self._init_sessions(only)
                time.sleep(0.2)

    def _init_sessions(self, only):
        self.sessions = []
        sessions = {}
        for key in TDB_HANDLER.iterkeys():
            #key must endswith \x00
            data = TDB_HANDLER.get(key)
            if data is None:
                continue

            #(tid, ) = struct.unpack("<L", data[4:8])
            sdata = data.split(separator)
            #parse les colonnes de tdb a la recherche du nom de la socket
            #l'IP est utilisé dans la socket
            for col in sdata:
                col = str(col)
                if col[:5] == 'ipv4:' and col[-4:] != ':445':
                    socket = col
                    ip = socket[5:].split(':')[0]
                    break
            #le nom d'utilisateur est dans la dernière colonne
            if only is not None:
                if ip != only:
                    continue
            username = sdata[-2]
            if username == '':
                continue
            if self.is_user_account(username):
                sessions.setdefault(ip, []).append((socket, username))
        self.sessions = remove_duplicated_user_for_ip(sessions)

    def is_user_account(self, nom):
        if not nom.endswith('$'):
            ldap_conn = Ldap()
            if ldap_conn.get_user_attributs('%s'%nom) != {}:
                return True

    def get_users_by_ip(self, ip):
        """renvoi users par ip
        """
        ret = []
        for uid, _ip in self.sessions:
            if _ip == ip:
                ret.append(uid)
        return ret

    def get_sessions_by_ip(self, ip):
        """renvoi les sessions d'une IP
        """
        ret = []
        for uid, _ip in self.sessions:
            if _ip == ip:
                ret.append((uid, _ip))
        return ret

    def has_session(self, ip):
        for uid, _ip in self.sessions:
            if _ip == ip:
                return ip

    def is_connected(self, user):
        for _user, _ in self.sessions:
            if _user == user:
                return user

    def get_ip(self, user):
        """retourne l'ip de la (des) station(s) ou est connecte <user>
        """
        res = []
        for _user, _ip in self.sessions:
            if _user == user:
                res.append(_ip)
        return res

class Connexions:
    def __init__(self):
        #self.db = MySQLdb.connect(host=mysql_host, user='controlevnc',
        #        passwd=mysql_password, db='controlevnc')
        #self.cursor = self.db.cursor()
        self.sessions = None

    #def __del__(self):
    #    self.db.commit()
    #    self.db.close()

    #def service_start(self, ip, mac):
    #    """met True à up dans la base de donnée pour l'IP correspondante
    #    """
    #    self.cursor.execute("SELECT up FROM log WHERE ip='%s'" % ip)
    #    row = self.cursor.fetchone()
    #    if row:
    #        if row[0] != True:
    #            #si l'ip est déjà dans la base n'est pas up=True
    #            self.cursor.execute("UPDATE log SET up=True, mac='%s' WHERE ip='%s'" % (mac, ip))
    #    else:
    #        #si l'IP n'existe pas dans la base, creer la machine
    #        self.cursor.execute("INSERT INTO log (ip, up, mac) VALUES ('%s', True, '%s')" \
    #                % (ip, mac))
    #    return True

    #def service_stop(self, ip):
    #    """met False à up dans la base de donnée pour l'IP correspondante
    #    """
    #    self.cursor.execute("SELECT up FROM log WHERE ip='%s'" % ip)
    #    row = self.cursor.fetchone()
    #    if row:
    #        if row[0] != False:
    #            #si l'ip est déjà dans la base n'est pas up=False
    #            self.cursor.execute("UPDATE log SET up=False WHERE ip='%s'"%ip)
    #    return True

    #def get_stations(self):
    #    """
    #    retourne la liste des machines dans la base de donnée des machines
    #    """
    #    self.cursor.execute("SELECT netbios, ip, mac FROM log")
    #    ret = []
    #    for row in self.cursor.fetchall():
    #        ret.append(','.join(row))
    #    return ';'.join(ret)

    #def get_station_up(self, verify):
    #    """
    #    retourne la liste des machines dans la base de donnée des machines
    #    avec session ouverte (information du Client Scribe).
    #    Si verify (True|False):
    #    - comparaison avec la liste des sessions samba ;
    #    - test si la présence du port 8788 (Client Scribe), dans ce cas le nom
    #    de l'utilisation n'est pas mentionné).
    #    """
    #    #FIXME : devrait ajouter les machines de la session nom présente dans
    #    #bdd
    #    self.cursor.execute("SELECT ip, netbios, user FROM log WHERE up=True")
    #    ret = []
    #    session_ips = [ip for user, ip in self.get_sessions().sessions]
    #    for row in self.cursor.fetchall():
    #        #si le poste a une session samba ou est accessible sur le port 8788
    #        if not verify or row[0] in session_ips:
    #            ret.append(', '.join(row))
    #        elif test_tcp(row[0], 8788):
    #            ret.append("%s, %s," % (row[0], row[1]))
    #    return ';'.join(ret)

    #def get_connected_by_group(self, group):
    #    """voir les connecter pour un groupe"""
    #    sql = "SELECT ip, user, os, prim_group, netbios FROM log WHERE up=True and ip IN "
    #    sql += "(SELECT ip FROM `group` WHERE groupname='%s');" % group
    #    self.cursor.execute(sql)
    #    members = []
    #    ip_infos = {}
    #    for row in self.cursor.fetchall():
    #        ip, user, os, prim_group, netbios = row
    #        members.append(user)
    #        ip_infos[ip] = (os, prim_group, netbios)

    #    sessions = self.get_sessions()
    #    liste = []
    #    #FIXME : supprimer les comptes en trop dans la bdd !
    #    for username, ip in sessions.sessions:
    #        try:
    #            if username not in members:
    #                continue
    #            os, prigrp, netbios = ip_infos[ip]

    #            liste.append((username, prigrp, netbios, os, ip))
    #        except:
    #            continue
    #    liste.sort()
    #    return liste

    #def get_connected_student(self, group=None):
    #    """renvoie la liste des connectes pour n'avoir que les élèves du
    #    groupe [USERNAME]
    #    """
    #    # retourne que les eleves
    #    prigrp = "eleves"
    #    # récupération des connectés
    #    #croise parce que cherche prigrp eleves + groupe + connecté
    #    """retourne les utilisateurs présent dans 2 groupes"""
    #    sql = "SELECT ip, os, user, netbios FROM log WHERE up=True and ip IN "
    #    if group is None:
    #        sql += "(SELECT ip FROM `group` WHERE groupname='%s')" % prigrp
    #    else:
    #        sql += "(SELECT ip FROM `group` WHERE ip IN "
    #        sql += "(SELECT ip FROM `group` WHERE groupname='%s')" % prigrp
    #        sql += "AND groupname='%s');" % group
    #    self.cursor.execute(sql)
    #    membres = []
    #    ip_infos = {}
    #    for row in self.cursor.fetchall():
    #        ip, os, user, netbios = row
    #        membres.append(user)
    #        ip_infos[ip] = (os, netbios)
    #    # le groupe est vide
    #    if not membres:
    #        return []
    #    sessions = self.get_sessions()
    #    liste = []
    #    for user, ip in sessions.sessions:
    #        try:
    #            # uid, grp, machine, os(détecté), ip
    #            if user not in membres:
    #                continue
    #            os, nom_mach = ip_infos[ip]

    #            liste.append((user, prigrp, nom_mach, os, ip))
    #        except:
    #            continue
    #    liste.sort()
    #    return liste

    #def get_os_from_ip(self, ip):
    #    sql = "SELECT os FROM log WHERE ip='%s'" % ip
    #    self.cursor.execute(sql)
    #    row = self.cursor.fetchone()
    #    if row:
    #        return row[0]

    #def get_ip_from_netbios(self, netbios):
    #    sql = "SELECT ip FROM log WHERE netbios='%s'" % netbios
    #    self.cursor.execute(sql)
    #    row = self.cursor.fetchone()
    #    if row:
    #        return row[0]

    #def get_netbios_from_ip(self, ip):
    #    sql = "SELECT netbios FROM log WHERE ip='%s'" % ip
    #    self.cursor.execute(sql)
    #    row = self.cursor.fetchone()
    #    if row:
    #        return row[0]

    #def get_mac_from_ip(self, ip):
    #    sql = "SELECT mac FROM log WHERE ip='%s'" % ip
    #    self.cursor.execute(sql)
    #    row = self.cursor.fetchone()
    #    if row:
    #        return row[0]

    #def get_netbios(self):
    #    sql = "SELECT netbios FROM log"
    #    self.cursor.execute(sql)
    #    ret = []
    #    row = self.cursor.fetchall()
    #    if row:
    #        for r in row:
    #            ret.append(r[0])
    #    return ret

    def get_sid(self, user):
        return adsid.get_sid(user)

    #def get_sessions(self, only=None):
    #    if not self.sessions:
    #        self.sessions = Session(only)
    #    return self.sessions

    #def get_infos(self, ip, os_type):
    #    sessions = self.get_sessions(only=ip)
    #    users = sessions.get_users_by_ip(ip)

    #    #récupération des informations sur l'utilisateur dans la base de données
    #    #FIXME manque UP
    #    sql = "SELECT user, sid, display_name, os, netbios FROM log "
    #    sql += "WHERE ip='%s'" % ip
    #    self.cursor.execute(sql)
    #    row = self.cursor.fetchone()
    #    if row:
    #        # Si personne dans la session
    #        # ou un et un seul utilisateur identique à la base de donnée
    #        # ou l'utilisateur de la base est dans la liste des sessions
    #        # (il arrive que net status sessions renvoi plusieurs utilisateurs
    #        # retourne les valeurs de la base
    #        # et si _os n'est pas vide
    #        user, sid, display_name, _os, netbios = row
    #        if users == [] or (len(users) == 1 and users[0] == user) or \
    #                (len(users) > 1 and user in users) and _os:
    #            groups = self._get_sql_groups(ip)
    #            if activer_ad == 'oui':
    #                sid = adsid.get_sid(user)
    #            return user, sid, display_name, groups, _os, netbios
    #    # si pas d'utilisateur dans la base de donnée
    #    # et dans net sessions status
    #    if users == []:
    #        raise Exception("Personne ne s'est connecte sur %s"%ip)
    #    # utilisateur de la base et connecté différent
    #    # ou pas d'utilisateur dans la base de donnée
    #    # fait confiance à net status sessions
    #    # on récupère les informations dans LDAP
    #    user = users[-1]

    #    ldap_conn = Ldap()
    #    user_attrib = ldap_conn.get_user_attributs(user)
    #    try:
    #        sid = user_attrib['sambaSID'][0].strip()
    #    except:
    #        raise Exception('utilisateur inconnu {0}, les informations de la session sont {1}'.format(user, sessions.sessions))
    #    display_name = user_attrib['displayName'][0].strip()
    #    gidnumber = user_attrib['gidNumber'][0].strip()
    #    groups = []
    #    for dn, grp in ldap_conn.get_groups(user):
    #        name = grp['cn'][0]
    #        if grp['gidNumber'][0] == gidnumber:
    #            prim_group = name
    #        groups.append(name)
    #    del(ldap_conn)
    #    netbios = "" # sessions.get_netbios(ip) => le netbios n'est plus disponible dans l'objet session

    #    # met à jour la base de donnée
    #    log_connexion_db(user, sid, display_name, prim_group, groups, netbios,
    #            os_type, ip)

    #    return user, sid, display_name, groups, os_type, netbios

    #def _get_sql_groups(self, ip):
    #    """retourne les groupes de l'utilisateur connecté à une IP sans
    #    vérifier l'utilisateur"""
    #    sql = "SELECT groupname FROM `group` WHERE ip='%s'" % ip
    #    self.cursor.execute(sql)
    #    groups = [group[0] for group in self.cursor.fetchall()]
    #    return groups

    def get_groups(self, ip):
        """retourne les groupes de l'utilisateur connecter sur IP
        """
        sessions = self.get_sessions(ip)
        users = sessions.get_users_by_ip(ip)

        #récupération des informations sur l'utilisateur dans la base de données
        sql = "SELECT user FROM log WHERE up=True AND ip='%s'" % ip
        self.cursor.execute(sql)
        user = self.cursor.fetchone()
        if user:
            # Si personne dans la session
            # ou un et un seul utilisateur identique à la base de donnée
            # ou l'utilisateur de la base est dans la liste des sessions
            # (il arrive que net status sessions renvoi plusieurs utilisateurs
            # retourne les valeurs de la base
            if users == [] or (len(users) == 1 and users[0] == user) or \
                    (len(users) > 1 and user in users):
                #si pas vide
                return self._get_sql_groups(ip)

        # si pas d'utilisateur dans la base de donnée
        # et dans net sessions status
        if users == []:
            raise Exception("Personne ne s'est connecte sur %s"%ip)
        # utilisateur de la base et connecté différent
        # ou pas d'utilisateur dans la base de donnée
        # fait confiance à net status sessions
        # on récupère les informations dans LDAP
        user = users[-1]

        ldap_conn = Ldap()
        groups = []
        for dn, grp in ldap_conn.get_groups(user):
            groups.append(grp['cn'][0])
        del(ldap_conn)

        return groups

    #def get_user_from_ip(self, ip):
    #    """retourne l'utilisateur connecté sur ip (#13163)
    #    """
    #    return self.get_user(ip)

    #def get_user(self, ip):
    #    """retourne l'utilisateur connecter sur IP
    #    """
    #    sessions = self.get_sessions(ip)
    #    users = sessions.get_users_by_ip(ip)

    #    #récupération des informations sur l'utilisateur dans la base de données
    #    sql = "SELECT user FROM log WHERE up=True AND ip='%s'" % ip
    #    self.cursor.execute(sql)
    #    row = self.cursor.fetchone()
    #    if row:
    #        user = row
    #        # Si personne dans la session
    #        # ou un et un seul utilisateur identique à la base de donnée
    #        # ou l'utilisateur de la base est dans la liste des sessions
    #        # (il arrive que net status sessions renvoi plusieurs utilisateurs
    #        # retourne les valeurs de la base
    #        if users == [] or (len(users) == 1 and users[0] == user) or \
    #                (len(users) > 1 and user in users):
    #            #si pas vide
    #            return user

    #    # si pas d'utilisateur dans la base de donnée
    #    # et dans net sessions status
    #    if users == []:
    #        raise Exception("Personne ne s'est connecte sur %s"%ip)
    #    # utilisateur de la base et connecté différent
    #    # ou pas d'utilisateur dans la base de donnée
    #    # fait confiance à net status sessions
    #    # on récupère les informations dans LDAP
    #    return users[-1]

    def isprof(self, ip):
        """renvoie True si l'utilisateur connecté sur <ip> est membre de
        "professeurs"
        """
        if ip == master_ip:
            return True
        return False

    #def isadmin(self, ip):
    #    """renvoie True si l'utilisateur connecté sur <ip> est membre de
    #    "DomainAdmins"
    #    """
    #    if ip == master_ip:
    #        return True
    #    return 'DomainAdmins' in self.get_groups(ip)

    #def has_session(self, ip):
    #    sessions = self.get_sessions(ip)
    #    return sessions.has_session(ip)

    #def is_connected(self, user):
    #    sessions = self.get_sessions()
    #    return sessions.is_connected(user) == user
