# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# autorisations.py
#
# Librairie de gestion des droits sur les remote_<fonctions>
#
###########################################################################

import sys
sys.path.append('/usr/share/eole/controlevnc')

#from scribe.backend_conf import *

# gestion des connexions
from connexions import Connexions

# gestion de l'annuaire
import ldap_utils
from config import master_ip

def isprof(ip):
    """renvoie True si l'utilisateur connecté sur <ip> est membre de "professeurs"
    """
    if ip == master_ip: return True
    return test_groupe(ip, 'professeurs')

def isadmin(ip):
    """renvoie True si l'utilisateur connecté sur <ip> est membre de "DomainAdmins"
    """
    if ip == master_ip: return True
    return test_groupe(ip, 'DomainAdmins')

def test_groupe(ip, groupe):
    """renvoie True si l'utilisateur connecté sur <ip> est membre de <groupe>
    """
    try: user = Connexions().get_active_user(ip)
    except: return
    if not user: return
    groups = ldap_utils.get_user_groups(user)
    if groupe in groups: return user
    return

