<?php
/**
 * Gère les actions liées aux destinataires.
 *
 * PHP 5
 */

class DestinatairesController extends Controller {

	protected $_extAllowed = array(
		'xls',
		'ods'
		);

	protected $_destTmp = array();

	protected $_destQueue = array();

	/**
	 * Permet de mettr à jour la liste des destinataires
	 * @param  string $token TOKEN du sondage
	 * @return void
	 */
	public function update( $token, $create = false ){
		$this->autoRender = false;

		if (!$this->request->data) {
			$this->error("400", 400, "Bad Request");
		}
		$this->loadModel('Destinataire');

		$postData = $this->request->data;
		$errors = false;
		$added = 0;
		$this->loadModel('Sondage');
		$sondage = $this->Sondage->findFirst(array('conditions' => array('token' => $token)));

		if (!empty($sondage)) {
			foreach ($postData->dest as $k => $v) {
				if (!empty($v)) {
					if (filter_var($v, FILTER_VALIDATE_EMAIL)) {
						$data = array(
							'sondage_id' => $token,
							'mail' => $v
							);
						$this->Destinataire->save($data);
						// Envoi du mail d'invitation

						if ($sondage->published == 1) {
							// si le sondage est publié alors on envoi un mail d'invitation à chaque nouveau destinataire
							list(, $extension) = explode('@', $v);
							if ($extension == MAIL_TO_CAS) {
								$link_to_polls = HOST.URL.'/sondage/resp/'.$token.'/'.md5(MAIL_TO_CAS.$token);
							} else {
								$link_to_polls = HOST.URL.'/sondage/resp/'.$token;
							}

							// bundary
							$boundary = "-----=".md5(rand());

							// headers
							$headers  = 'MIME-Version: 1.0' . "\r\n";
							$headers .= 'Content-type: text/html; charset=utf8' . "\r\n";
							$headers .= 'From: '.Conf::$nameApp.' <'.Conf::$noreply_mail.'>' . "\r\n";

							// sujet
							$sujet = "[".Conf::$nameApp."] ".$sondage->titre;

							// Récupération du template pour l'envoi de mail
							ob_start();
							require ROOT . DS . 'view' . DS . 'mails' . DS . 'invitation.php';
							$body = ob_get_clean();
							mail($v,$sujet, $body, $headers);
						}

						$added++;
						if(!$errors) {
							$dests = $this->Destinataire->find(array('conditions' => array('sondage_id' => $token)));
							$s_sondage = $this->Session->read('sondages');
							$s_sondage->dests = $dests;
							$this->Session->write('sondages', $s_sondage);

							if ($added <= 1)
								$this->Session->setFlash("Destinataire enregistré. Un mail d'invitation lui a été envoyé.", 'success');
							else
								$this->Session->setFlash("Destinataires enregistrés. Un mail d'invitation a été envoyé.", 'success');
						}
					} else {
						$errors = true;
						$this->Session->setFlash($v . " n'est pas une adresse email valide. Veuillez la corriger.", 'danger');
					}
				}
			}
		}

		if (!$create) {
			$_SESSION['active_pan'] = "dest";
			return $this->redirect('/sondage/edit/' . $token );
		}
		else
			return $this->redirect('/destinataires/' . $token);
	}

	/**
	 * Permet de supprimer un utilisateur d'un sondage
	 * @param  int $id    ID de l'utilisateur
	 * @param  string $token TOKEN du sondage
	 * @return [type]        [description]
	 */
	public function delete( $id, $token, $create = false) {
		$this->autoRender = false;

		$this->loadModel('Destinataire');
		$user = $this->Destinataire->findFirst(array(
			'conditions' => array(
				'id' => $id,
				'sondage_id' => $token
				)
			));

		if (empty($user)) {
			$this->Session->setFlash("Impossible de supprimer cet utilisateur.", 'danger');
		} else {
			$this->Destinataire->delete($id);
			$this->Session->setFlash("<b>" . $user->mail . "</b> ne fait plus partie des invités.", 'success');
		}

		if (!$create)
			return $this->redirect('/sondage/edit/' . $token );
		else
			return $this->redirect('/destinataires/' . $token );
	}

	public function import( $sondage_id, $edit = false ) {
		//echo $sondage_id; die();
		$this->autoRender = false;
		$this->loadLib('PHPExcel', 'PHPExcel/');

		if (!empty($_FILES['list'])) {
			$file = $_FILES['list'];
			$path = $file['name'];
			$ext = pathinfo($path, PATHINFO_EXTENSION);

			if ($this->_checkExtension($ext)) {
				$inputFileType = PHPExcel_IOFactory::identify($file['tmp_name']);

				$objReader = PHPExcel_IOFactory::createReader($inputFileType);

				$object = $objReader->load($file['tmp_name']);
				if (!empty($object)) {
					$sheet = $object->getSheet(0);
					$reader_content =  $sheet->toArray();
				} else {
					$reader_content = false;
				}

				// Si la liste n'est pas vide on ajoute les destinataures
				// à dans la pile
				if ($reader_content) {
					$this->loadModel('Destinataire');

					foreach ($reader_content as $k => $dest) {
						$destExist = $this->Destinataire->findFirst(array(
							'conditions' => array(
								'sondage_id' => $sondage_id,
								'mail' => $dest[0]
								)
							));

						if (empty($destExist) AND !in_array($dest[0], $this->_destTmp))
							array_push($this->_destTmp, $dest[0]);
					}
					if (count($this->_destTmp) > Conf::$limDestinataire) {
						$this->Session->setFlash("Vous ne pouvez pas inviter plus de ".Conf::$limDestinataire." personnes.", "danger");
					} else {
						try {
							foreach ($this->_destTmp as $k => $dest) {
								$data = array(
									'sondage_id' => $sondage_id,
									'mail' => $dest
									);
								$this->Destinataire->save($data);
							}

							$this->Session->setFlash("Les destinataires ont été importé avec succès!");
						}catch(Exception $e) {
							die($e->getMessage());
						}

					}
				}
			} else {
				$this->Session->setFlash("Veuillez envoyer un fichier .xlsx, .xls ou .ods", "danger");
			}
		} else {
			$this->Session->setFlash("Veuillez sélectionner un fichier.", "danger");
		}

		if (!$edit)
			return $this->redirect('/destinataires/' . $sondage_id);
		else {
			$_SESSION['active_pan'] = "dest";
			return $this->redirect('/sondage/edit/' . $sondage_id );
		}
	}

	/**
	 * Test si l'extension d'un fichier est dans la liste blanche
	 * @param  string $ext Valeur de l'extension
	 * @return boolean
	 */
	protected function _checkExtension( $ext ) {

		return in_array($ext, $this->_extAllowed);

	}

	public function autocomplete()
	{
		$this->autoRender = false;
		$term = htmlspecialchars($_GET['term']);
		$mails = array();
		if ($term != '*')
			$mails = array_slice($this->getLdapAutoComplete(array(), $term, 10), 0,10);
		echo json_encode($mails);
	}

	private function getLdapAutoComplete($field, $term, $limit) {

		try{
			require ROOT . DS . 'config' . DS . 'ldap.inc.php';
			$ldapconn = ldap_connect($ldaphost,$ldapport) or die("Impossible de se connecter au serveur LDAP {$ldaphost}");
			$response = array();
			if($ldapconn){
				$ldapbind = ldap_bind($ldapconn);
		 		if($ldapbind){
	    		$filtre = $ldap_mail."=*".$term."*";
	        $read = ldap_search($ldapconn ,$ldapdn ,$filtre, array($ldap_mail), 0);
	        $info = ldap_get_entries($ldapconn,$read);

					foreach($info as $k => $data)
	        {
						if (is_numeric($k)) {
							array_push($response, $data['mail'][0]);
						}
	        }
		      return $response;
		    	}else{
		       		echo 'Connexion LDAP anonmye échouée';
		    	}
			}else{
				echo 'Erreur de connection au serveur LDAP';
			}
			ldap_close($ldapconn);
		}catch(Exception $e){
			echo 'Exception : '.$e->getMessage();
		}
		return $response;

	}

}
