<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="sidebar")
 * @ORM\HasLifecycleCallbacks()
 *
 */
class Sidebar
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     */
    private $roworder;

    /**
     * @ORM\Column(type="string", length=250)
     */
    private $label;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $path;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $fonticon;

    /**
     * @ORM\Column(type="simple_array", length=250, nullable=true)
     */
    private $permission;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $appactivate;    

    /**
     * @ORM\ManyToOne(targetEntity="Sidebar", inversedBy="childs")
     * @ORM\JoinColumn(nullable=true)
     */
    private $parent;    

    /**
     * @var ArrayCollection $childs
     * @var Child
     *
     * @ORM\OneToMany(targetEntity="Sidebar", mappedBy="parent", cascade={"persist"}, orphanRemoval=false)
     * @ORM\OrderBy({"roworder" = "ASC"})
     */
    private $childs;   
        
    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set roworder
     *
     * @param integer $roworder
     *
     * @return Sidebar
     */
    public function setRoworder($roworder)
    {
        $this->roworder = $roworder;

        return $this;
    }

    /**
     * Get roworder
     *
     * @return integer
     */
    public function getRoworder()
    {
        return $this->roworder;
    }

    /**
     * Set label
     *
     * @param string $label
     *
     * @return Sidebar
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Set path
     *
     * @param string $path
     *
     * @return Sidebar
     */
    public function setPath($path)
    {
        $this->path = $path;

        return $this;
    }

    /**
     * Get path
     *
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * Set fonticon
     *
     * @param string $fonticon
     *
     * @return Sidebar
     */
    public function setFonticon($fonticon)
    {
        $this->fonticon = $fonticon;

        return $this;
    }

    /**
     * Get fonticon
     *
     * @return string
     */
    public function getFonticon()
    {
        return $this->fonticon;
    }

    /**
     * Set permission
     *
     * @param array $permission
     *
     * @return Sidebar
     */
    public function setPermission($permission)
    {
        $this->permission = $permission;

        return $this;
    }

    /**
     * Get permission
     *
     * @return array
     */
    public function getPermission()
    {
        return $this->permission;
    }

    /**
     * Set appactivate
     *
     * @param string $appactivate
     *
     * @return Sidebar
     */
    public function setAppactivate($appactivate)
    {
        $this->appactivate = $appactivate;

        return $this;
    }

    /**
     * Get appactivate
     *
     * @return string
     */
    public function getAppactivate()
    {
        return $this->appactivate;
    }

    /**
     * Set parent
     *
     * @param Sidebar $parent
     *
     * @return Sidebar
     */
    public function setParent(Sidebar $parent = null)
    {
        $this->parent = $parent;

        return $this;
    }

    /**
     * Get parent
     *
     * @return Sidebar
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->childs = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add child
     *
     * @param Sidebar $child
     *
     * @return Sidebar
     */
    public function addChild(Sidebar $child)
    {
        $this->childs[] = $child;

        return $this;
    }

    /**
     * Remove child
     *
     * @param Sidebar $child
     */
    public function removeChild(Sidebar $child)
    {
        $this->childs->removeElement($child);
    }

    /**
     * Get childs
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getChilds()
    {
        return $this->childs;
    }
}
