<?php
namespace Cadoles\PortalBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * @ORM\Entity
 * @ORM\Table(name="flux")
 * @ORM\HasLifecycleCallbacks.
 * @ORM\Entity(repositoryClass="Cadoles\PortalBundle\Repository\FluxRepository")
  */
class Flux
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=100)
     */
    private $title;

    /**
     * @var integer
     *
     * @ORM\Column(name="rowOrder", type="integer", nullable=true)
     */
    private $rowOrder;

    /**
     * @var string
     *
     * @ORM\Column(name="url", type="text")
     */
    private $url;

    /**
     * @var string
     *
     * @ORM\Column(name="maxread", type="integer")
     */
    private $maxread;

    /**
     * @var integer
     *
     * @ORM\Column(name="color", type="string", nullable=true)
     */
    private $color;

    /**
     * @var string
     *
     * @ORM\Column(name="roles", type="array",  nullable=true)
     */
    private $roles;

    /**
     * @ORM\ManyToMany(targetEntity="Cadoles\CoreBundle\Entity\Group", inversedBy="fluxs", cascade={"persist"})
     * @ORM\JoinTable(name="fluxgroupe",
     *   joinColumns={@ORM\JoinColumn(name="flux", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    
    // A garder pour forcer l'id en init
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }


    /**
     * Constructor
     */
    public function __construct()
    {
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     *
     * @return Flux
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set rowOrder
     *
     * @param integer $rowOrder
     *
     * @return Flux
     */
    public function setRowOrder($rowOrder)
    {
        $this->rowOrder = $rowOrder;

        return $this;
    }

    /**
     * Get rowOrder
     *
     * @return integer
     */
    public function getRowOrder()
    {
        return $this->rowOrder;
    }

    /**
     * Set url
     *
     * @param string $url
     *
     * @return Flux
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * Get url
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Set maxread
     *
     * @param integer $maxread
     *
     * @return Flux
     */
    public function setMaxread($maxread)
    {
        $this->maxread = $maxread;

        return $this;
    }

    /**
     * Get maxread
     *
     * @return integer
     */
    public function getMaxread()
    {
        return $this->maxread;
    }

    /**
     * Set color
     *
     * @param string $color
     *
     * @return Flux
     */
    public function setColor($color)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * Get color
     *
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Set roles
     *
     * @param array $roles
     *
     * @return Flux
     */
    public function setRoles($roles)
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * Get roles
     *
     * @return array
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * Add group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     *
     * @return Flux
     */
    public function addGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     */
    public function removeGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }
}
