<?php

namespace Cadoles\PortalBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Blog
 *
 * @ORM\Entity
 * @ORM\Table(name="blog")
 * @ORM\Entity(repositoryClass="Cadoles\PortalBundle\Repository\BlogRepository")
 * @ORM\HasLifecycleCallbacks
 */
class Blog
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="roles", type="array",  nullable=true)
     */
    private $roles;

    /**
     * @ORM\ManyToMany(targetEntity="Cadoles\CoreBundle\Entity\Group", inversedBy="blogs", cascade={"persist"})
     * @ORM\JoinTable(name="bloggroupe",
     *   joinColumns={@ORM\JoinColumn(name="blog", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToOne(targetEntity="Cadoles\CoreBundle\Entity\User", inversedBy="blogs")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\ManyToMany(targetEntity="Cadoles\CoreBundle\Entity\User", inversedBy="blogwriters", cascade={"persist"})
     * @ORM\JoinTable(name="blogwriter",
     *   joinColumns={@ORM\JoinColumn(name="blog", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $writers;

    /**
     * @var ArrayCollection $blogarticle
     * @var Blogarticle
     *
     * @ORM\OneToMany(targetEntity="Cadoles\PortalBundle\Entity\Blogarticle", mappedBy="blog", cascade={"persist"}, orphanRemoval=true)
     */
    private $blogarticles;


    /* champs calculé non stocké en base */
    private $canupdate;
    public function getCanupdate()
    {
        return $this->canupdate;
    }    
    public function setCanupdate($canupdate)
    {
        $this->canupdate = $canupdate;
        return $this;
    }

    /* champs calculé non stocké en base */
    private $canadd;
    public function getCanadd()
    {
        return $this->canadd;
    }    
    public function setCanadd($canadd)
    {
        $this->canadd = $canadd;
        return $this;
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
        $this->writers = new \Doctrine\Common\Collections\ArrayCollection();
        $this->blogarticles = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Blog
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set roles
     *
     * @param array $roles
     *
     * @return Blog
     */
    public function setRoles($roles)
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * Get roles
     *
     * @return array
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * Add group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     *
     * @return Blog
     */
    public function addGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param \Cadoles\CoreBundle\Entity\Group $group
     */
    public function removeGroup(\Cadoles\CoreBundle\Entity\Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Set user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return Blog
     */
    public function setUser(\Cadoles\CoreBundle\Entity\User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return \Cadoles\CoreBundle\Entity\User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add writer
     *
     * @param \Cadoles\CoreBundle\Entity\User $writer
     *
     * @return Blog
     */
    public function addWriter(\Cadoles\CoreBundle\Entity\User $writer)
    {
        $this->writers[] = $writer;

        return $this;
    }

    /**
     * Remove writer
     *
     * @param \Cadoles\CoreBundle\Entity\User $writer
     */
    public function removeWriter(\Cadoles\CoreBundle\Entity\User $writer)
    {
        $this->writers->removeElement($writer);
    }

    /**
     * Get writers
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getWriters()
    {
        return $this->writers;
    }

    /**
     * Add blogarticle
     *
     * @param \Cadoles\PortalBundle\Entity\Blogarticle $blogarticle
     *
     * @return Blog
     */
    public function addBlogarticle(\Cadoles\PortalBundle\Entity\Blogarticle $blogarticle)
    {
        $this->blogarticles[] = $blogarticle;

        return $this;
    }

    /**
     * Remove blogarticle
     *
     * @param \Cadoles\PortalBundle\Entity\Blogarticle $blogarticle
     */
    public function removeBlogarticle(\Cadoles\PortalBundle\Entity\Blogarticle $blogarticle)
    {
        $this->blogarticles->removeElement($blogarticle);
    }

    /**
     * Get blogarticles
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBlogarticles()
    {
        return $this->blogarticles;
    }
}
