<?php

namespace Cadoles\PortalBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Form\FormError;

use Cadoles\PortalBundle\Entity\Page;
use Cadoles\PortalBundle\Form\PagetemplateSubmitType;
use Cadoles\PortalBundle\Form\PageSubmitType;
use Cadoles\PortalBundle\Form\PageUpdateToolType;
use Cadoles\PortalBundle\Form\PageUpdateURLType;
use Cadoles\PortalBundle\Form\PageUpdateWidgetType;
use Cadoles\PortalBundle\Form\PageUpdateEditorType;
use Cadoles\PortalBundle\Form\PageShareType;

class PagetemplateController extends Controller
{
    private $labelentity="CadolesPortalBundle:Page";
    private $routeprimary="cadoles_portal_config_pagetemplate";

    public function listAction()
    {
        return $this->render('CadolesPortalBundle:Pagetemplate:list.html.twig',[
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,
        ]);
    }

    public function ajaxlistAction(Request $request,$access="config")
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $em = $this->getDoctrine()->getManager();

        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');

        // Query de base
        $qbase=$em->createQueryBuilder()->from($this->labelentity,'table');
        $qsearch=$em->createQueryBuilder()->from($this->labelentity,'table');
        
        $qbase->where("table.user is null");
        $qbase->andWhere('table.parentfor is not null') ;
        $qsearch->where("table.user is null");
        $qsearch->andWhere('table.parentfor is not null') ;
        $qsearch->andwhere('table.id LIKE :value OR table.name LIKE :value OR table.parentfor LIKE :value');
        $qsearch->setParameter("value", "%".$search["value"]."%");                  

        // Nombre total d'enregistrement
        $total = $qbase->select('COUNT(table)')->getQuery()->getSingleScalarResult();
        

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else
            $totalf= $qsearch->select('COUNT(table)')->getQuery()->getSingleScalarResult();
        

        // Parcours des Enregistrement
        if($search["value"]=="")
            $qb = $qbase->select('table');
        else
            $qb = $qsearch->select('table');

        // Order
        switch($order[0]["column"]) {
            case 1 : 
            $qb->orderBy('table.roworder',$order[0]["dir"]);
            break;
            case 2 : 
            $qb->orderBy('table.name',$order[0]["dir"]);
            break;
            case 3 : 
            $qb->orderBy('table.parentfor',$order[0]["dir"]);
            break;            
        }

        // Execution de la requete d'affichage
        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );
        foreach($datas as $data) {

            $route=str_replace("_config_","_".$access."_",$this->routeprimary);
            $action = "";
            $action.="<a href='".$this->generateUrl($route.'_update', array('id'=>$data->getId()))."' title='Configurer'><i class='fa fa-cog fa-fw fa-2x'></i></a>";
            $action.="<a href='".$this->generateUrl($route.'_view', array('id'=>$data->getId()))."'><i class='fa fa-eye fa-fw fa-2x' title='Afficher'></i></a>";
            $action.="<a href='".$this->generateUrl($route.'_delete', array('id'=>$data->getId()))."' data-method='delete' title='Supprimer'><i class='fa fa-trash fa-fw fa-2x'></i></a>";

            array_push($output["data"],[
                $action,
                $data->getRoworder(),
                $data->getName(),
                $data->getParentfor(),
            ]);
        }

        // Retour
        return new Response(json_encode($output), 200);
    }  

    private function entityForm(Page $entity,$access="config")
    {
        $route=str_replace("_config_","_".$access."_",$this->routeprimary);

        if ($this->getDoctrine()->getManager()->contains($entity)) {
            return $this->createForm(PageUpdateWidgetType::class, $entity, [
                "mode"   => "update",
                "access" => $access,
                "for" => $entity->getParentfor(),
            ]);
        }
        else {
            return $this->createForm(PagetemplateSubmitType::class, $entity, [
                "mode"   => "update",
                "access" => $access
            ]);
        }
    }

    public function submitAction(Request $request,$access="config")
    {
        if($access=="user"&&!$this->get('session')->get('cancreatepage'))
            throw $this->createNotFoundException('Permission denied');

        $pagecategory=$this->getDoctrine()->getRepository("CadolesPortalBundle:Pagecategory")->find(2);
        $entity = new Page();
        $entity->setMaxwidth(0);
        $entity->setRoworder(0);
        $entity->setParentfor("user");
        $entity->setPagecategory($pagecategory);

        $form   = $this->entityForm($entity,$access);
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$entity,"submit");

        if ($form->isValid() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            if($access=="user") $entity->setUser($this->getUser());

            $em->persist($entity);
            $em->flush();

            $route=str_replace("_config_","_".$access."_",$this->routeprimary);
            return $this->redirect($this->generateUrl($route.'_update',["id"=>$entity->getId()]));
        }

        return $this->render('CadolesPortalBundle:Pagetemplate:submit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),     
            'maxwidth'          => ($access=="user"),     
            'entity'            => $entity,
            'mode'              => "submit",
            'access'            => $access,
            'form'              => $form->createView()
        ]);
    }

    public function updateAction(Request $request, $id,$access="config")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');
     
        
        // Création du formulaire
        $form = $this->entityForm($entity,$access);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl($this->routeprimary.'_view',["id"=>$id]));
        }

        return $this->render('CadolesPortalBundle:Page:updatewidget.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),    
            'maxwidth'          => ($access=="user"),                     
            'entity'            => $entity,
            'access'            => $access,
            'mode'              => "updatetemplate",
            'form'              => $form->createView(),
        ]);
    }

    public function deleteAction(Request $request, $id,$access="config")
    {
        $em = $this->getDoctrine()->getManager();
        $entity = $this->getDoctrine()->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');
    
        // On s'assure que l'utilisateur à la permission de supprimer
        if($access=="user") {
            $em->getRepository($this->labelentity)->getPermission($this->getUser(),$entity,$cansee,$canupdate);
            if(!$canupdate) throw $this->createNotFoundException('Permission denied');
        }
 

        $error=false;
        $this->get('session')->getFlashBag()->clear();
        
        $group = $em->getRepository("CadolesCoreBundle:Group")->findOneBy(["pagetemplate"=>$entity]);
        if($group ) {
            $error=true;
            $request->getSession()->getFlashBag()->add("error", "Impossible de supprimer ce modèle, il est utilisé par au moins un groupe");            
        }

        if($entity->getParentfor()=="app") {
            $error=true;
            $request->getSession()->getFlashBag()->add("error", "Vous ne pouvez pas supprimer un template de type Application");            
        }

        if(!$error) {
            // Suppression
            $em->remove($entity);
            $em->flush();
        } 

        // Retour
        return $this->redirect($this->generateUrl($this->routeprimary));

    }

    public function ajaxseleclistAction(Request $request)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $em = $this->getDoctrine()->getManager();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        $usage=$request->query->get('usage');

        $qb = $em->createQueryBuilder();
        $qb->select('table')->from("CadolesPortalBundle:Page",'table')
           ->where('table.name LIKE :value')
           ->andWhere('table.parentfor=:usage')
           ->setParameter("value", "%".$q."%")
           ->setParameter("usage", $usage)
           ->orderBy('table.name');
        
        $datas=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();
        foreach($datas as $data) {
            array_push($output,array("id"=>$data->getId(),"text"=>$data->getName()));
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    } 

    public function viewAction($id,$access=null) {

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        // Permissions
        $canupdate = true;

        return $this->render($this->labelentity.':viewwidget.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),                    
            'entity'            => $entity,
            'access'            => $access,
            'canupdate'         => $canupdate,
            'mode'              => "viewtemplate",
            'widgets'           => $this->getDoctrine()->getRepository("CadolesPortalBundle:Widget")->getWidgetAccess($access),
            'usage'             => "config",
            'group'             => "",
            'look'              => "view",
            'selwidget'         => null,
        ]);
    }

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {          
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" )) {
            if($data->getParentfor()=="app") {
                $tmp=$this->getDoctrine()->getRepository("CadolesPortalBundle:Page")->findOneBy(["parentfor"=>"app"]);
                if($tmp) $form->addError(new FormError("Il ne peut avoir qu'un seul template de type Application"));
            }
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();
            $validator = $this->get('validator');
            $errors = $validator->validate($data);
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }     
}
