<?php
namespace Cadoles\CoreBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\HttpFoundation\Session\Session;

use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Gregwar\CaptchaBundle\Type\CaptchaType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class RegistrationType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $session = new Session();
        $fields=$options["fields"];
        if(!is_array($fields)) $fields=[];
        
        $builder->add('submit',
            SubmitType::class, array(
                "label"       => ($options["mode"]=="delete"?"Confirmer la Suppression":($options["mode"]=="submit"?"Confirmer":"Enregistrer et envoyer le mail")),
                "attr"        => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            )
        );

        if($options["mode"]=="send") {
            $builder->add('save',
                SubmitType::class, array(
                    "label"       => "Enregistrer sans envoyer le mail",
                    "attr"        => array("class" => "btn btn-success")
                )
            );

            $builder->add('note',
                TextareaType::class, array(
                    "label"       => "Notes Administrateur",
                    "required"    => false,
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px; height: 130px")
                )
            );             
        }

        # Obligatoire
        $builder->add('username',
            TextType::class, array(
                "label"       =>"Login",
                "disabled"    => ($options["mode"]=="submit"?false:true),
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px", "autocomplete" => "new-password")
            )
        );

        $builder->add('lastname',
            TextType::class, array(  
                "label"       =>"Nom de Famille",
                "disabled"    => ($options["mode"]=="delete"?true:false),
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
            )
        );

        $builder->add('email',
            EmailType::class, array(
                "label" =>"Mail",
                "disabled" => ($options["mode"]=="delete"?true:false),
                "attr" => array("class" => "form-control", "style" => "margin-bottom:15px")
            )
        );

        $builder->add('niveau01',
            EntityType::class,
            array("class"        => "CadolesCoreBundle:Niveau01",
                  "label"        => $session->get('labelniveau01'),
                  'placeholder'  => '== Choisir '.$session->get('labelniveau01').' ==',
                  "choice_label" => "label",              
                  "query_builder"=> function (EntityRepository $er) {
                        return $er->createQueryBuilder('niveau01')->orderBy('niveau01.label','ASC');
                  },
                  "disabled"     => ($options["mode"]=="delete"?true:false),
                  "attr"         => array("class" => "form-control", "style" => "margin-bottom:15px","readonly" => ($options["mode"]=="delete"?true:false))));        


        $builder->add('niveau01other',
            TextType::class, array(  
                "label"       =>"Autre ".$session->get('labelniveau01'). " *",
                "disabled"    => ($options["mode"]=="delete"?true:false),
                "required"    => false,
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
            )
        );

        # Password
        if($options["mode"]!="delete"&&$options["mode"]!="send") {
            $builder->add('password',
                RepeatedType::class, array(
                    "type" => PasswordType::class,
                    "required" => ($options["mode"]=="submit"?true:false),
                    "first_options"  => array("label" => "Mot de Passe","attr" => array("class" => "form-control", "style" => "margin-bottom:15px", "autocomplete" => "new-password")),
                    "second_options" => array('label' => 'Confirmer Mot de Passe',"attr" => array("class" => "form-control", "style" => "margin-bottom:15px")),
                    "invalid_message" => "Mot de passe non valide"
                )
            );
            
            $builder->add('captcha',
                CaptchaType::class,array(
                    "width" => 200,
                    "height" => 50,
                    "length" => 6,
                )
            );
        }                  


        # En fonction de datauser
        if(!array_key_exists("firstname",$fields)||$fields["firstname"]["perm"]!=0) {
            $builder->add('firstname',
                TextType::class, array(  
                    "label"       =>"Prénom",
                    "required"    => (!array_key_exists("firstname",$fields)?false:($fields["firstname"]["perm"]==2)),
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
                )
            );
        }

        if(!array_key_exists("visible",$fields)||$fields["visible"]["perm"]!=0) {
            $choices=array("oui" => "1","non" => "0");
            $builder->add("visible",
                ChoiceType::class,array(
                    "label"       =>"Visible",
                    "required"    => (!array_key_exists("visible",$fields)?false:($fields["visible"]["perm"]==2)),
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px"),
                    "choices"     => $choices
                )
            );
        }

        if(!array_key_exists("usualname",$fields)||$fields["usualname"]["perm"]!=0) {
            $builder->add('usualname',
                TextType::class, array(
                    "label"       => "Nom d'Usage",
                    "required"    => (!array_key_exists("usualname",$fields)?false:($fields["usualname"]["perm"]==2)),
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
                )
            );  
        }
        
        if(!array_key_exists("givensname",$fields)||$fields["givensname"]["perm"]!=0) {
            $builder->add('givensname',
                TextType::class, array(
                    "label"       => "Autre Prénom",
                    "required"    => (!array_key_exists("givensname",$fields)?false:($fields["givensname"]["perm"]==2)),
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
                )
            ); 
        }
      
        if(!array_key_exists("telephonenumber",$fields)||$fields["telephonenumber"]["perm"]!=0) {
            $builder->add('telephonenumber',
                TextType::class, array(
                    "label"       => "Téléphone",
                    "required"    => (!array_key_exists("telephonenumber",$fields)?false:($fields["telephonenumber"]["perm"]==2)),
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
                )
            );  
        }
       
        if(!array_key_exists("postaladress",$fields)||$fields["postaladress"]["perm"]!=0) {
            $builder->add('postaladress',
                TextareaType::class, array(
                    "label"       => "Adresse",
                    "required"    => (!array_key_exists("postaladress",$fields)?false:($fields["postaladress"]["perm"]==2)),
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px; height: 90px")
                )
            );  
        }

        if(!array_key_exists("birthdate",$fields)||$fields["birthdate"]["perm"]!=0) {
            $builder->add('birthdate',
                DateType::class, array(
                    "label"       => "Date de Naissance",
                    "required"    => (!array_key_exists("birthdate",$fields)?false:($fields["birthdate"]["perm"]==2)),
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "widget"       => 'single_text',
                    "format"       => "dd/MM/yyyy",
                    "html5"        => false,
                    "attr"         => array("class" => "form-control js-datepicker", "style" => "margin-bottom:15px","readonly" => ($options["mode"]=="delete"?true:false)
                    )
                )
            );
        }        
   
        if(!array_key_exists("gender",$fields)||$fields["gender"]["perm"]!=0) {
            $choices=array("" => "", "homme" => "male","femme" => "female");
            $builder->add("gender",
                ChoiceType::class,array(
                    "label"       =>"Sexe",
                    "required"    => (!array_key_exists("gender",$fields)?false:($fields["gender"]["perm"]==2)),
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px"),
                    "choices"     => $choices
                )
            );
        }         

        if(!array_key_exists("job",$fields)||$fields["job"]["perm"]!=0) {
            $builder->add('job',
                TextType::class, array(
                    "label"       => "Métier",
                    "required"    => (!array_key_exists("job",$fields)?false:($fields["job"]["perm"]==2)),
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
                )
            ); 
        }         

        if(!array_key_exists("position",$fields)||$fields["position"]["perm"]!=0) {
            $builder->add('position',
                TextType::class, array(
                    "label"       => "Fonction",
                    "required"    => (!array_key_exists("position",$fields)?false:($fields["position"]["perm"]==2)),
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                    "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
                )
            ); 
        }
       

        if(!array_key_exists("birthcountry",$fields)||$fields["birthcountry"]["perm"]!=0) {
            $builder->add('birthcountry',
                Select2EntityType::class, array(
                    'label' => "Pays de Naissance",
                    "disabled" => ($options["mode"]=="delete"?true:false),
                    "required"    => (!array_key_exists("birthcountry",$fields)?false:($fields["birthcountry"]["perm"]==2)),
                    'multiple' => false,
                    'remote_route' => 'cadoles_core_ajax_country_list',
                    'class' => 'Cadoles\coreBundle\Entity\Country',
                    'primary_key' => 'id',
                    'text_property' => 'label',
                    'minimum_input_length' => 2,
                    'page_limit' => 10,
                    'allow_clear' => true,
                    'delay' => 250,
                    'cache' => false,
                    'cache_timeout' => 60000, // if 'cache' is true
                    'language' => 'fr',
                    'placeholder' => 'Selectionner un pays',
                    'attr' => array("class" => "form-control", "style" => "margin-bottom:15px")
                )
            );
        }

        if(!array_key_exists("birthplace",$fields)||($fields["birthcountry"]["perm"]!=0&&$fields["birthplace"]["perm"]!=0)) {
            $builder->add('birthplace',
                Select2EntityType::class, array(
                    'label' => "Ville de Naissance",
                    "disabled" => ($options["mode"]=="delete"?true:false),
                    "required" => false,
                    'multiple' => false,
                    'remote_route' => 'cadoles_core_ajax_city_list',
                    'class' => 'Cadoles\coreBundle\Entity\City',
                    'primary_key' => 'id',
                    'text_property' => 'label',
                    'minimum_input_length' => 2,
                    'page_limit' => 10,
                    'allow_clear' => true,
                    'delay' => 250,
                    'cache' => false,
                    'cache_timeout' => 60000, // if 'cache' is true
                    'language' => 'fr',
                    'placeholder' => 'Selectionner une ville',
                    'attr' => array("class" => "form-control", "style" => "margin-bottom:15px")
                )
            ); 
        }
        
        if($session->get('viewniveau02')) {
            if(!array_key_exists("niveau02",$fields)||$fields["niveau02"]["perm"]!=0) {
                $builder->add('niveau02',
                    Select2EntityType::class, array(
                        'label' => $session->get('labelniveau02'),
                        "disabled" => ($options["mode"]=="delete"?true:false),
                        "required"    => (!array_key_exists("niveau02",$fields)?false:($fields["niveau02"]["perm"]==2)),
                        'multiple' => false,
                        'remote_route' => 'cadoles_core_ajax_niveau02_list',
                        'class' => 'Cadoles\coreBundle\Entity\Niveau02',
                        'req_params' => ['niveau01' => 'parent.children[niveau01]'],
                        'primary_key' => 'id',
                        'text_property' => 'label',
                        'minimum_input_length' => 0,
                        'page_limit' => 10,
                        'allow_clear' => true,
                        'delay' => 250,
                        'cache' => false,
                        'cache_timeout' => 60000, // if 'cache' is true
                        'language' => 'fr',
                        'placeholder' => 'Selectionner '.$session->get('labelniveau02'),
                        'attr' => array("class" => "form-control", "style" => "margin-bottom:15px")
                    )
                );         
            }
        }       

        $builder->add('motivation',
            TextareaType::class, array(
                "label"       => "Motivation",
                "required"    => false,
                "disabled"    => ($options["mode"]=="delete"?true:false),
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px; height: 90px")
            )
        );         
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Cadoles\CoreBundle\Entity\Registration',
            'mode' => "string",
            'fields' => "array"
        ));
    }
}
