<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;

use Cadoles\CoreBundle\Entity\Niveau01;
use Cadoles\CoreBundle\Form\Niveau01Type;

class Niveau01Controller extends Controller
{
    private $labelroute  = 'cadoles_core_config_niveau01';
    private $labelentity = 'CadolesCoreBundle:Niveau01';
    private $labeldata   = 'niveau01';
    private $labeldatas  = 'niveau01s';

    public function listAction()
    {
      	return $this->render('CadolesCoreBundle:Niveau01:list.html.twig',[
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
        ]);
    }

    public function ajaxlistAction(Request $request)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $em = $this->getDoctrine()->getManager();
        
        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');
      
        // Modo ?
        $ismodo=false;
        if($this->getUser()->getRole()=="ROLE_MODO") {
            $ismodo=true;
        }

        // Nombre total d'enregistrement
        if($ismodo)
            $total = $em->createQueryBuilder()->select('COUNT(table)')->from("CadolesCoreBundle:UserModo",'table')->where("table.user = :user")->setParameter("user", $this->getUser())->getQuery()->getSingleScalarResult();
        else
            $total = $em->createQueryBuilder()->select('COUNT(table)')->from($this->labelentity,'table')->getQuery()->getSingleScalarResult();

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else {
            $qb = $em->createQueryBuilder()
                        ->select('COUNT(table)')
                        ->from($this->labelentity,'table')
                        ->where('table.label LIKE :value')
                        ->setParameter("value", "%".$search["value"]."%");
            if($ismodo)
                $qb ->from("CadolesCoreBundle:UserModo","usermodo")
                    ->andwhere("usermodo.user = :user")
                    ->andWhere("usermodo.niveau01=table")
                    ->setParameter("user", $this->getUser());
            
            
            $totalf = $qb->getQuery()->getSingleScalarResult();
        }

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );

        // Parcours des Enregistrement
        $qb = $em->createQueryBuilder();
        $qb->select('table')->from($this->labelentity,'table');
        if($ismodo) {
            $qb->from("CadolesCoreBundle:UserModo","usermodo")
                ->where("usermodo.user = :user")
                ->andWhere("usermodo.niveau01=table")
                ->setParameter("user", $this->getUser());
        }
        
        if($search["value"]!="") {
            $qb ->andwhere('table.label LIKE :value')
                ->setParameter("value", "%".$search["value"]."%");
        }
        switch($order[0]["column"]) {
            case 1 : 
            $qb->orderBy('table.label',$order[0]["dir"]);
            break;
        }

        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();

        foreach($datas as $data) {
            $action ="<a href='".$this->generateUrl('cadoles_core_config_niveau01_update', array('id'=>$data->getId()))."' title='Modifier'><i class='fa fa-file fa-fw fa-2x'></i></a>";
            if($data->getId()>0&&!$ismodo) $action.="<a href='".$this->generateUrl('cadoles_core_config_niveau01_delete', array('id'=>$data->getId()))."' title='Supprimer'><i class='fa fa-trash fa-fw fa-2x'></i></a>";
            array_push($output["data"],array($action,$data->getLabel()));
        }

        // Retour
        return new Response(json_encode($output), 200);
    }    

    public function submitAction(Request $request)
    {
        // Initialisation de l'enregistrement
        $data = new Niveau01();
        
        // Interdit pour les modos
        if($this->getUser()->getRole()=="ROLE_MODO")
            throw $this->createNotFoundException('Permission denied');

        // Création du formulaire
        $form = $this->createForm(Niveau01Type::class,$data,array(
            "mode"              => "submit",
            "labelsiren"        => $this->GetParameter("labelsirenniveau01"),
            "masteridentity"    => $this->GetParameter("masteridentity")
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            $em = $this->getDoctrine()->getManager();
            
            // Sauvegarde
            $em->persist($data);
            $em->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'form'              => $form->createView()
        ]);
    }  

    public function updateAction($id,Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        // Récupération de l'enregistrement courant 
        $data=$this->getData($id);
        
        // Modification modo que si niveau modéré 
        if($this->getUser()->getRole()=="ROLE_MODO") {
            $usermodo=$em->getRepository("CadolesCoreBundle:UserModo")->findOneBy(["user"=>$this->getUser(),"niveau01"=>$data]);
            if(!$usermodo) throw $this->createNotFoundException('Permission denied');
        }
                                    
        // Création du formulaire
        $form = $this->createForm(Niveau01Type::class,$data,array(
            "mode"              => "update",
            "labelsiren"        => $this->GetParameter("labelsirenniveau01"),
            "masteridentity"    => $this->GetParameter("masteridentity")
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();
            
            // Sauvegarde
            $em->persist($data);
            $em->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
       
        // Affichage du formulaire
        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,               
            $this->labeldata    => $data,
            'mode'              => 'update',
            'form'              => $form->createView()
        ]);
    }

    public function deleteAction($id,Request $request)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($id);

        // Interdit pour les modos
        if($this->getUser()->getRole()=="ROLE_MODO")
            throw $this->createNotFoundException('Permission denied');

        // Création du formulaire
        $form = $this->createForm(Niveau01Type::class,$data,array(
            "mode"              =>"delete",
            "labelsiren"        => $this->GetParameter("labelsirenniveau01"),
            "masteridentity"    => $this->GetParameter("masteridentity")            
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);        

        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"delete");
                
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($data);
            $em->flush();
            
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
            $this->labeldata    => $data,
            'mode'              => 'delete',
            'form'              => $form->createView()
        ]);                    
    }

    public function logoAction()
    {
        return $this->render('CadolesCoreBundle:Niveau01:logo.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
        ]);
    }

    public function headerAction()
    {
        return $this->render('CadolesCoreBundle:Niveau01:header.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
        ]);
    }

    protected function getDatas()
    {
        $em = $this->getDoctrine()->getManager();
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($id)
    {
        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getEntityBy($entity,$key,$value)
    {
        $em = $this->getDoctrine()->getManager();
        $datas = $em->createQueryBuilder()
                      ->select('u')
                      ->from($entity,  'u')
                      ->where('u.'.$key.'=:value')
                      ->getQuery()->setParameter("value", $value)
                      ->getResult();
        if (!$datas) return false;
        else return true;
    }

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
            // On s'assure que le niveau01 n'est pas rattaché à des utilisateurs
            if($data->getUsers()->count() > 0) {
                $form->addError(new FormError('Un utilisateur utilise ce niveau de rang 01 : suppression impossible'));
            }

            if($data->getRegistrations()->count() > 0) {
                $form->addError(new FormError('Une inscription utilise ce niveau de rang 01 : suppression impossible'));
            }

            if($data->getNiveau02s()->count() > 0) {
                $form->addError(new FormError('Un niveau de rang 02 utilise ce niveau de rang 01 : suppression impossible'));
            }    
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
            $tmp=$this->getEntityBy("CadolesCoreBundle:Group","label",$data->getLabel());
            if($tmp) $form->addError(new FormError('Un groupe utilise déjà ce label'));

            $tmp=$this->getEntityBy("CadolesCoreBundle:Niveau02","label",$data->getLabel());
            if($tmp) $form->addError(new FormError('Un niveau de rang 02 utilise déjà ce label'));

            // On s'assure que le label ne contient pas des caractères speciaux
            $string = preg_replace('~[^ éèêôöàïî\'@a-zA-Z0-9._-]~', '', $data->getLabel());
            if($string!=$data->getLabel())
            {
                $form->addError(new FormError('Caractères interdit dans ce label'));
            }            
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();
            $validator = $this->get('validator');
            $errors = $validator->validate($data);
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
