<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;

class BookmarkType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add("submit", SubmitType::class, [
                "label"       => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"        => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add("title", TextType::class, [
                "label"         => "Titre",
                "disabled"      => ($options["mode"]=="delete"?true:false),
            ])

            ->add("subtitle", TextareaType::class, [
                "label"         => 'Sous Titre',
                "required"      => false,
                "disabled"      => ($options["mode"]=="delete"?true:false),
                "attr"          => array("rows" => '4')
            ])            


            ->add('color', TextType::class, [
                'label'         => "Couleur",
                'required'      => false,
                'attr'          => array("class" => "pick-a-color")              
            ])

            ->add('url')

            ->add('target', ChoiceType::class, [
                "label" => 'Ouvrir le lien dans',
                "choices" => [
                    "Nouvel onglet/fenêtre" => '_blank',
                    "iFrame"                => 'frame',
                    "Onglet courant"        => '_self',
                ]
            ])

            ->add('idicon', HiddenType::class,['mapped'=> false,'data' => $options["idicon"]]);
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Bookmark',
            'mode' => "string",
            'idicon' => "string",
        ]);
    }
}
