<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;


/**
 * @ORM\Entity
 * @ORM\Table(name="bookmark")
 * @ORM\HasLifecycleCallbacks
 */
class Bookmark
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=100)
     */
    private $title;

    /**
     * @var string
     *
     * @ORM\Column(name="subtitle", type="string", length=250, nullable=true)
     */
    private $subtitle;

    /**
     * @var string
     *
     * @ORM\Column(name="url", type="string", length=500)
     */
    private $url;

    /**
     * @var string
     *
     * @ORM\Column(name="target", type="string", length=32)
     */
    private $target;

    /**
     * @var integer
     *
     * @ORM\Column(name="rowOrder", type="integer", nullable=true)
     */
    private $rowOrder;

    /**
     * @var string
     *
     * @ORM\Column(name="color", type="string", length=24,  nullable=true)
     */
    private $color;

    /**
     * @ORM\ManyToOne(targetEntity="Icon", inversedBy="bookmarks")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $icon;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="bookmarks")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Pagewidget", inversedBy="bookmarks")
     * @ORM\JoinColumn(nullable=true)
     */
    private $pagewidget;

    /**
     * @ORM\ManyToOne(targetEntity="Item", inversedBy="bookmarks")
     * @ORM\JoinColumn(nullable=true)
     */
    private $item;    



    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     *
     * @return Bookmark
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set subtitle
     *
     * @param string $subtitle
     *
     * @return Bookmark
     */
    public function setSubtitle($subtitle)
    {
        $this->subtitle = $subtitle;

        return $this;
    }

    /**
     * Get subtitle
     *
     * @return string
     */
    public function getSubtitle()
    {
        return $this->subtitle;
    }

    /**
     * Set url
     *
     * @param string $url
     *
     * @return Bookmark
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * Get url
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Set target
     *
     * @param string $target
     *
     * @return Bookmark
     */
    public function setTarget($target)
    {
        $this->target = $target;

        return $this;
    }

    /**
     * Get target
     *
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * Set rowOrder
     *
     * @param integer $rowOrder
     *
     * @return Bookmark
     */
    public function setRowOrder($rowOrder)
    {
        $this->rowOrder = $rowOrder;

        return $this;
    }

    /**
     * Get rowOrder
     *
     * @return integer
     */
    public function getRowOrder()
    {
        return $this->rowOrder;
    }

    /**
     * Set color
     *
     * @param string $color
     *
     * @return Bookmark
     */
    public function setColor($color)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * Get color
     *
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Set icon
     *
     * @param Icon $icon
     *
     * @return Bookmark
     */
    public function setIcon(Icon $icon = null)
    {
        $this->icon = $icon;

        return $this;
    }

    /**
     * Get icon
     *
     * @return Icon
     */
    public function getIcon()
    {
        return $this->icon;
    }

    /**
     * Set user
     *
     * @param User $user
     *
     * @return Bookmark
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set pagewidget
     *
     * @param Pagewidget $pagewidget
     *
     * @return Bookmark
     */
    public function setPagewidget(Pagewidget $pagewidget = null)
    {
        $this->pagewidget = $pagewidget;

        return $this;
    }

    /**
     * Get pagewidget
     *
     * @return Pagewidget
     */
    public function getPagewidget()
    {
        return $this->pagewidget;
    }

    /**
     * Set item
     *
     * @param Item $item
     *
     * @return Bookmark
     */
    public function setItem(Item $item = null)
    {
        $this->item = $item;

        return $this;
    }

    /**
     * Get item
     *
     * @return Item
     */
    public function getItem()
    {
        return $this->item;
    }
}
