<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Blogcomment
 *
 * @ORM\Entity
 * @ORM\Table(name="blogcomment")
 * @ORM\HasLifecycleCallbacks
 */
class Blogcomment
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
    * @var string
    *
    * @ORM\Column(name="description", type="text", nullable=true)
    */
    private $description;

    /**
     * @ORM\Column(name="submit", type="datetime")
     */
    private $submit;   

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="blogcomments")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Blogarticle", inversedBy="blogcomments")
     * @ORM\JoinColumn(nullable=false)
     */
    private $blogarticle;

    /**
     * @ORM\ManyToOne(targetEntity="Blogcomment", inversedBy="childs")
     */
    private $parent;

    /**
     * @ORM\OneToMany(targetEntity="Blogcomment", mappedBy="parent", cascade={"persist"}, orphanRemoval=true)
     */
    protected $childs;  

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Blogcomment
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Blogcomment
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set submit
     *
     * @param \DateTime $submit
     *
     * @return Blogcomment
     */
    public function setSubmit($submit)
    {
        $this->submit = $submit;

        return $this;
    }

    /**
     * Get submit
     *
     * @return \DateTime
     */
    public function getSubmit()
    {
        return $this->submit;
    }

    /**
     * Set user
     *
     * @param User $user
     *
     * @return Blogcomment
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }


    /**
     * Set blogarticle
     *
     * @param Blogarticle $blogarticle
     *
     * @return Blogcomment
     */
    public function setBlogarticle(Blogarticle $blogarticle)
    {
        $this->blogarticle = $blogarticle;

        return $this;
    }

    /**
     * Get blogarticle
     *
     * @return Blogarticle
     */
    public function getBlogarticle()
    {
        return $this->blogarticle;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->childs = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Set parent
     *
     * @param Blogcomment $parent
     *
     * @return Blogcomment
     */
    public function setParent(Blogcomment $parent = null)
    {
        $this->parent = $parent;

        return $this;
    }

    /**
     * Get parent
     *
     * @return Blogcomment
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Add child
     *
     * @param Blogcomment $child
     *
     * @return Blogcomment
     */
    public function addChild(Blogcomment $child)
    {
        $this->childs[] = $child;

        return $this;
    }

    /**
     * Remove child
     *
     * @param Blogcomment $child
     */
    public function removeChild(Blogcomment $child)
    {
        $this->childs->removeElement($child);
    }

    /**
     * Get childs
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getChilds()
    {
        return $this->childs;
    }
}
