<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;
use Doctrine\Persistence\ManagerRegistry;

use App\Entity\Niveau01;
use App\Form\Niveau01Type;

class Niveau01Controller extends AbstractController
{
    private $nameentity  = 'Niveau01';
    private $labelroute  = 'app_core_config_niveau01';
    private $labelentity = 'App\Entity\Niveau01';
    private $labeldata   = 'niveau01';
    private $labeldatas  = 'niveau01s';

    public function list()
    {
      	return $this->render($this->nameentity.'\list.html.twig',[
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
        ]);
    }

    public function ajaxlist(Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
               
        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');
      
        // Modo ?
        $ismodo=false;
        if($this->getUser()->getRole()=="ROLE_MODO") {
            $ismodo=true;
        }

        // Nombre total d'enregistrement
        if($ismodo)
            $total = $em->getManager()->createQueryBuilder()->select('COUNT(table)')->from("App\Entity\UserModo",'table')->where("table.user = :user")->setParameter("user", $this->getUser())->getQuery()->getSingleScalarResult();
        else
            $total = $em->getManager()->createQueryBuilder()->select('COUNT(table)')->from($this->labelentity,'table')->getQuery()->getSingleScalarResult();

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else {
            $qb = $em->getManager()->createQueryBuilder()
                        ->select('COUNT(table)')
                        ->from($this->labelentity,'table')
                        ->where('table.label LIKE :value')
                        ->setParameter("value", "%".$search["value"]."%");
            if($ismodo)
                $qb ->from("App\Entity\UserModo","usermodo")
                    ->andwhere("usermodo.user = :user")
                    ->andWhere("usermodo.niveau01=table")
                    ->setParameter("user", $this->getUser());
            
            
            $totalf = $qb->getQuery()->getSingleScalarResult();
        }

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );

        // Parcours des Enregistrement
        $qb = $em->getManager()->createQueryBuilder();
        $qb->select('table')->from($this->labelentity,'table');
        if($ismodo) {
            $qb->from("App\Entity\UserModo","usermodo")
                ->where("usermodo.user = :user")
                ->andWhere("usermodo.niveau01=table")
                ->setParameter("user", $this->getUser());
        }
        
        if($search["value"]!="") {
            $qb ->andwhere('table.label LIKE :value')
                ->setParameter("value", "%".$search["value"]."%");
        }
        switch($order[0]["column"]) {
            case 1 : 
            $qb->orderBy('table.label',$order[0]["dir"]);
            break;
        }

        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();

        foreach($datas as $data) {
            $action ="<a href='".$this->generateUrl('app_core_config_niveau01_update', array('id'=>$data->getId()))."' title='Modifier'><i class='fa fa-file fa-fw fa-2x'></i></a>";
            if($data->getId()>0&&!$ismodo) $action.="<a href='".$this->generateUrl('app_core_config_niveau01_delete', array('id'=>$data->getId()))."' title='Supprimer'><i class='fa fa-trash fa-fw fa-2x'></i></a>";
            array_push($output["data"],array($action,$data->getLabel()));
        }

        // Retour
        return new Response(json_encode($output), 200);
    }    

    public function submit(Request $request, ManagerRegistry $em)
    {
        // Initialisation de l'enregistrement
        $data = new Niveau01();
        
        // Interdit pour les modos
        if($this->getUser()->getRole()=="ROLE_MODO")
            throw $this->createNotFoundException('Permission denied');

        // Création du formulaire
        $form = $this->createForm(Niveau01Type::class,$data,array(
            "mode"              => "submit",
            "labelsiren"        => $this->GetParameter("labelsirenniveau01"),
            "masteridentity"    => $this->GetParameter("masteridentity")
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$em,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            
            // Sauvegarde
            $em->getManager()->persist($data);
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'form'              => $form->createView()
        ]);
    }  

    public function update($id,Request $request, ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        
        // Modification modo que si niveau modéré 
        if($this->getUser()->getRole()=="ROLE_MODO") {
            $usermodo=$em->getRepository("App\Entity\UserModo")->findOneBy(["user"=>$this->getUser(),"niveau01"=>$data]);
            if(!$usermodo) throw $this->createNotFoundException('Permission denied');
        }
                                    
        // Création du formulaire
        $form = $this->createForm(Niveau01Type::class,$data,array(
            "mode"              => "update",
            "labelsiren"        => $this->GetParameter("labelsirenniveau01"),
            "masteridentity"    => $this->GetParameter("masteridentity")
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$em,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();
            
            // Sauvegarde
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
       
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,               
            $this->labeldata    => $data,
            'mode'              => 'update',
            'form'              => $form->createView()
        ]);
    }

    public function delete($id,Request $request, ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);

        // Interdit pour les modos
        if($this->getUser()->getRole()=="ROLE_MODO")
            throw $this->createNotFoundException('Permission denied');

        // Création du formulaire
        $form = $this->createForm(Niveau01Type::class,$data,array(
            "mode"              =>"delete",
            "labelsiren"        => $this->GetParameter("labelsirenniveau01"),
            "masteridentity"    => $this->GetParameter("masteridentity")            
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);        

        // Sur erreur
        $this->getErrorForm($id,$em,$form,$request,$data,"delete");
                
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $em->getManager()->remove($data);
            $em->getManager()->flush();
            
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
            $this->labeldata    => $data,
            'mode'              => 'delete',
            'form'              => $form->createView()
        ]);                    
    }

    public function logo()
    {
        return $this->render($this->nameentity.'\logo.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
        ]);
    }

    public function header()
    {
        return $this->render($this->nameentity.'\header.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
        ]);
    }

    protected function getDatas($em)
    {
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($em,$id)
    {
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getEntityBy($em,$entity,$key,$value)
    {
        $datas = $em->getManager()->createQueryBuilder()
                      ->select('u')
                      ->from($entity,  'u')
                      ->where('u.'.$key.'=:value')
                      ->getQuery()->setParameter("value", $value)
                      ->getResult();
        if (!$datas) return false;
        else return true;
    }

    protected function getErrorForm($id,$em,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
            // On s'assure que le niveau01 n'est pas rattaché à des utilisateurs
            if($data->getUsers()->count() > 0) {
                $form->addError(new FormError('Un utilisateur utilise ce niveau de rang 01 : suppression impossible'));
            }

            if($data->getRegistrations()->count() > 0) {
                $form->addError(new FormError('Une inscription utilise ce niveau de rang 01 : suppression impossible'));
            }

            if($data->getNiveau02s()->count() > 0) {
                $form->addError(new FormError('Un niveau de rang 02 utilise ce niveau de rang 01 : suppression impossible'));
            }    
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
            $tmp=$this->getEntityBy($em,"App\Entity\Group","label",$data->getLabel());
            if($tmp) $form->addError(new FormError('Un groupe utilise déjà ce label'));

            $tmp=$this->getEntityBy($em,"App\Entity\Niveau02","label",$data->getLabel());
            if($tmp) $form->addError(new FormError('Un niveau de rang 02 utilise déjà ce label'));

            // On s'assure que le label ne contient pas des caractères speciaux
            $string = preg_replace('~[^ éèêôöàïî\'@a-zA-Z0-9._-]~', '', $data->getLabel());
            if($string!=$data->getLabel())
            {
                $form->addError(new FormError('Caractères interdit dans ce label'));
            }            
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
