<?php
namespace App\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Finder\Finder;
use Ramsey\Uuid\Uuid;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Id\AssignedGenerator;

use App\Entity\Group;
use App\Entity\UserGroup;
use App\Entity\PermModoProfil;
use App\Entity\PermModo;
use App\Entity\Cron;
use App\Entity\Widget;
use App\Entity\Icon;
use App\Entity\Projecttasktag;
use App\Entity\Projecttaskstatus;
use App\Entity\Pagecategory;
use App\Entity\Alertcategory;
use App\Entity\Itemcategory;
use App\Entity\Item;
use App\Entity\Page;
use App\Entity\Pagewidget;
use App\Entity\Appexternal;
use App\Entity\Flux;

class InitCommand extends Command
{
    private $container;
    private $em;

    public function __construct(ContainerInterface $container, EntityManagerInterface $em)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
    }

    protected function configure()
    {
        $this
            ->setName('app:Init')
            ->setDescription('Init Data for App')
            ->setHelp('This command Init Data App')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('');
        $output->writeln('CORE = Default Data');

        $em = $this->em;
        $masteridentity=$this->container->getParameter('masteridentity');
        $ldap_template = $this->container->getParameter('ldap_template');

		$finder = new Finder();
    	$finder->in('src/Command/data');

        // Init 01 = ce qui templetisé
        $output->writeln('  > Parametres 01');
        $finder->name('core-init-01.sql');
    	foreach( $finder as $file ){
        	$content = $file->getContents();

            $stmt = $em->getConnection()->prepare($content);
            $stmt->execute();
    	}

        // Init 02 = ce qui est toujours le cas
        $output->writeln('  > Parametres 02');
        $finder->name('core-init-02.sql');
    	foreach( $finder as $file ){
        	$content = $file->getContents();

        	$stmt = $em->getConnection()->prepare($content);
        	$stmt->execute();
        }

        // Init country
        $output->writeln('  > Pays');
        $finder->name('country.sql');
        foreach( $finder as $file ){
            $content = $file->getContents();

            $stmt = $em->getConnection()->prepare($content);
            $stmt->execute();
            
        }

        // Init city
        $output->writeln('  > Villes');
        $finder->name('city.sql');
        foreach( $finder as $file ){
            $content = $file->getContents();

            $stmt = $em->getConnection()->prepare($content);
            $stmt->execute();
            
        }
        $stmt->closeCursor();

        // On s'assure que l'admin à un password et sinon on l'init à la valeur du genconfig
        $user=$em->getRepository('App\Entity\User')->findOneBy(['username'=>'admin']);
        if($user&&(empty($user->getPassword())||$user->getPassword()=="PWD_CAS")) {
            $initpwdadmin=$this->container->getParameter('initpwdadmin');
            if(empty($initpwdadmin)) $initpwdadmin=$this->container->getParameter('app_secret');
            $output->writeln('  > Initialisation passsword admin / '.$initpwdadmin.' : pensez à modfier votre password après connexion');
            $user->setPassword($initpwdadmin);
            $em->flush();               
        }

        if($user&&empty($user->getApikey())) {
            $output->writeln('  > Initialisation apiKey admin');
            $user->setApikey(Uuid::uuid4());
            $em->flush();               
        }


        // On s'assure que les LDAP_USERSADMIN sont ROLE_ADMIN
        $ldap_usersadmin=$this->container->getParameter('ldap_usersadmin');
        foreach($ldap_usersadmin as $uidadmin) {
            $user=$em->getRepository('App\Entity\User')->findOneBy(['username'=>$uidadmin]);
            if($user&&!$user->hasRole("ROLE_ADMIN")) {
                $user->setRole("ROLE_ADMIN");
                $em->flush(); 
            }
        }

        // On s'assure que le groupe 'Tout le Monde' existe
        $group=$em->getRepository('App\Entity\Group')->findOneBy(array('fgall'=>true));
        if (!$group) {
            $output->writeln('  > Création du groupe Tout le Monde');
            $group = new Group();
            $group->setLabel("Tout le Monde");
            $group->setFgopen(false);
            $group->setFgall(true);
            $group->setFgtemplate(false);
            $group->setFgcanshare(false);
            $group->setFgcancreatepage(true);
            $group->setFgcancreateblog(true);
            $group->setFgcancreatecalendar(true);
            $group->setFgcancreateproject(true);
            $em->persist($group);
            $em->flush();            
        }

        $sub = $em->createQueryBuilder();
        $sub->select("usergroup");
        $sub->from("App\Entity\UserGroup","usergroup");
        $sub->andWhere('usergroup.user = user.id');
        $sub->andWhere('usergroup.group = :groupid');

        $qb = $em->createQueryBuilder();
        $qb->select('user')
           ->from('App\Entity\User','user')
           ->where($qb->expr()->not($qb->expr()->exists($sub->getDQL())))
           ->setParameter("groupid",$group->getId());
        $datas=$qb->getQuery()->getArrayResult();
        $nbusers=0;
        foreach($datas as $data) {
            $nbusers++;
            $user=$em->getRepository('App\Entity\User')->find($data["id"]);
            $group=$em->getRepository('App\Entity\Group')->findOneBy(array('fgall'=>true));

            $output->writeln("  $nbusers sur ".count($datas)." > Ratachement ".$user->getId()." ".$user->getUsername());
            $key = Uuid::uuid4();
            $usergroup=new UserGroup();
            $usergroup->setUser($user);
            $usergroup->setGroup($group);
            $usergroup->setKeyvalue($key);
            $usergroup->setRolegroup(0);            
            $em->persist($usergroup);
            $em->flush();             
            $em->clear();             
            //$user=$em->getRepository('App\Entity\User')->find($data["id"]);
        }

        // On s'assure si masteridentity est à LDAP qu'au minimum un niveau01 possède un filtre LDAP
        if($masteridentity=="LDAP") {
            $niveau01=$em->createQueryBuilder()->select('n')->from('App\Entity\Niveau01','n')->where('n.ldapfilter IS NOT NULL')->getQuery()->getResult();
            if(!$niveau01) {
                // Si ce n'est pas le cas on positionne un filtre ultra large sur le niveau01 de base
                $niveau01=$group=$em->getRepository('App\Entity\Niveau01')->find(-100);

                if($ldap_template=="scribe")
                    $niveau01->setLdapfilter("(&(uid=*)(objectclass=inetOrgPerson)(!(description=Computer)))");
                else
                    $niveau01->setLdapfilter($this->container->getParameter('openldapreqniveau01'));
                
                $em->persist($niveau01);
                $em->flush();             
            }
        }

        // On s'assure si masteridentity est à SSO qu'au minimum un niveau01 possède un attribut
        if($masteridentity=="SSO") {
            $niveau01=$em->createQueryBuilder()->select('n')->from('App\Entity\Niveau01','n')->where('n.attributes IS NOT NULL')->getQuery()->getResult();
            if(!$niveau01) {
                // Si ce n'est pas le cas on positionne un attribut ultra large sur le niveau01 de base
                $niveau01=$group=$em->getRepository('App\Entity\Niveau01')->find(-100);
                $niveau01->setAttributes('{"username":"*"}');
               
                $em->persist($niveau01);
                $em->flush();             
            }
        }

        // Génération du profils de permissions modérateurs
        $metadata = $em->getClassMetaData('App\Entity\PermModoProfil');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());        

        $entityprofil = $em->getRepository('App\Entity\PermModoProfil')->find(-100);
        if(!$entityprofil) {
            $entityprofil = new PermModoProfil();
            $entityprofil->setId(-100);
            $entityprofil->setName("Global");
            $em->persist($entityprofil);
            $em->flush();
        }

        // Affecter les permissions modérateurs sans profils sur le profils par défaut
        $entitys = $em->getRepository('App\Entity\PermModo')->findBy(["permmodoprofil"=>null]);
        foreach($entitys as $entity) {
            $entity->setPermmodoprofil($entityprofil);
            $em->persist($entity);
            $em->flush();
        }

        // Affecter le profil modérateur par défaut aux modérateurs qui n'en ont pas
        $users = $em->getRepository('App\Entity\User')->findBy(["role"=>"ROLE_MODO","permmodoprofil"=>null]);
        foreach($users as $user) {
            $user->setPermmodoprofil($entityprofil);
            $em->persist($user);
            $em->flush();
        }

        // Initialiser l'ensemble des profils modérateurs
        $entityprofils = $em->getRepository('App\Entity\PermModoProfil')->findAll();
        foreach($entityprofils as $profil) {
            $this->addModeration($profil,'app_core_config_commun',0);
            $this->addModeration($profil,'app_core_config_theme',0);
            $this->addModeration($profil,'app_core_config_datauser',0);
            $this->addModeration($profil,'app_core_config_datausers',0);
            $this->addModeration($profil,'app_core_config_whitelist',0);
            $this->addModeration($profil,'app_core_config_niveau01',1);
            $this->addModeration($profil,'app_core_config_niveau02',1);
            $this->addModeration($profil,'app_core_config_group',1);
            $this->addModeration($profil,'app_core_config_registration',1);
            $this->addModeration($profil,'app_core_config_user',1);
            $this->addModeration($profil,'app_portal_config_pagetemplate',1);
            $this->addModeration($profil,'app_portal_config_page',1);
            $this->addModeration($profil,'app_portal_config_item',1);
            $this->addModeration($profil,'app_portal_config_alert',1);
            $this->addModeration($profil,'app_portal_config_calendar',1);
            $this->addModeration($profil,'app_portal_config_blog',1);
            $this->addModeration($profil,'app_portal_config_project',1);
            $this->addModeration($profil,'app_portal_config_flux',1);
            $this->addModeration($profil,'app_portal_config_notice',1);
            $this->addModeration($profil,'app_portal_config_icon',1);
            $this->addModeration($profil,'app_portal_config_syncbalado',0);
            $this->addModeration($profil,'app_portal_config_synccdt',0);
            $this->addModeration($profil,'app_portal_config_syncgepiannu',0);
            $this->addModeration($profil,'app_portal_config_syncgepisiecle',0);
            $this->addModeration($profil,'app_portal_config_synclimesurvey',0);
            $this->addModeration($profil,'app_portal_config_syncmoodle',0);
            $this->addModeration($profil,'app_portal_config_syncnextcloud',0);
            $this->addModeration($profil,'app_portal_config_syncsacoche',0);
            $this->addModeration($profil,'app_portal_config_syncpiwik',0);
            $this->addModeration($profil,'app_portal_config_syncwordpress',0);

            $this->addModeration($profil,'app_core_config_statistic',1);
            $this->addModeration($profil,'app_core_config_mailing',1);
            $this->addModeration($profil,'app_core_config_importuser',0);
            $this->addModeration($profil,'app_cron_config',0);
            $this->addModeration($profil,'app_cron_config_log',0);
        }

        // Forcer le theme
        $force_theme=$this->container->getParameter('force_theme');
        if($force_theme) {

            // On force la configuration du theme
            $force_themename=$this->container->getParameter('force_themename');
            $config = $em->getRepository('App\Entity\Config')->find("theme");
            if($config) {
                $config->setValue($force_themename);
                $em->persist($config);
                $em->flush();                 
            }

            // On enlève l'accès de la sidebar
            $sidebar = $em->getRepository('App\Entity\Sidebar')->findOneBy(["path"=>"app_core_config_theme"]);
            if($sidebar) {
                $em->remove($sidebar);
                $em->flush();                
            }
        }

        $output->writeln('');


        $alias =$this->container->getParameter('alias');

        $activate_widadminer        = $this->container->getParameter('activate_widadminer');
        $activate_widbalado         = $this->container->getParameter('activate_widbalado');
        $activate_widcdt            = $this->container->getParameter('activate_widcdt');
        $activate_widdokuwiki       = $this->container->getParameter('activate_widdokuwiki');
        $activate_wideconnect       = $this->container->getParameter('activate_wideconnect');
        $activate_widead            = $this->container->getParameter('activate_widead');
        $activate_wideoe            = $this->container->getParameter('activate_wideoe');
        $activate_wideop            = $this->container->getParameter('activate_wideop');
        $activate_widetherhome      = $this->container->getParameter('activate_widetherhome');
        $activate_widfluxbb         = $this->container->getParameter('activate_widfluxbb');
        $activate_widgenconfig      = $this->container->getParameter('activate_widgenconfig');
        $activate_widgepi           = $this->container->getParameter('activate_widgepi');
        $activate_widglpi           = $this->container->getParameter('activate_widglpi');
        $activate_widgrr            = $this->container->getParameter('activate_widgrr');
        $activate_widkanboard       = $this->container->getParameter('activate_widkanboard');
        $activate_widlimesurvey     = $this->container->getParameter('activate_widlimesurvey');
        $activate_widmindmaps       = $this->container->getParameter('activate_widmindmaps');
        $activate_widmoodle         = $this->container->getParameter('activate_widmoodle');
        $activate_widnextcloud      = $this->container->getParameter('activate_widnextcloud');
        $activate_widnineboard      = $this->container->getParameter('activate_widnineboard');
        $activate_widnineschool     = $this->container->getParameter('activate_widnineschool');
        $activate_widninesurvey     = $this->container->getParameter('activate_widninesurvey');
        $activate_widonlyoffice     = $this->container->getParameter('activate_widonlyoffice');
        $activate_widopensondage    = $this->container->getParameter('activate_widopensondage');
        $activate_widphpldapadmin   = $this->container->getParameter('activate_widphpldapadmin');
        $activate_widpiwigo         = $this->container->getParameter('activate_widpiwigo');
        $activate_widpiwik          = $this->container->getParameter('activate_widpiwik');
        $activate_widroundcube      = $this->container->getParameter('activate_widroundcube');
        $activate_widsacoche        = $this->container->getParameter('activate_widsacoche');
        $activate_widwordpress      = $this->container->getParameter('activate_widwordpress');
        $activate_websocket         = $this->container->getParameter('websocket_activate');

        $widonlyoffice_sync         = $this->container->getParameter('widonlyoffice_sync');
        
        $output->writeln('PORTAL = Default Data');

        // afin de forcer les ID sur certaines entités
        $metadata = $em->getClassMetaData('App\Entity\Flux');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata = $em->getClassMetaData('App\Entity\Projecttasktag');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata = $em->getClassMetaData('App\Entity\Projecttaskstatus');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata = $em->getClassMetaData('App\Entity\Pagecategory');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata = $em->getClassMetaData('App\Entity\Page');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata = $em->getClassMetaData('App\Entity\Pagewidget');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata = $em->getClassMetaData('App\Entity\Alertcategory');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata = $em->getClassMetaData('App\Entity\Itemcategory');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata = $em->getClassMetaData('App\Entity\Item');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata = $em->getClassMetaData('App\Entity\Widget');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

//== APPEXTERNAL =========================================================================================================================================
        $output->writeln('  > Appexternal');

        $entity = $em->getRepository('App\Entity\Appexternal')->findoneby(["name"=>"Limesurvey"]);
        if(!$entity&&$activate_widlimesurvey) {
            $entity=new Appexternal;
            $entity->setName("Limesurvey");
            $em->persist($entity);
            $em->flush();
        }
        elseif($entity&&!$activate_widlimesurvey) {
            $em->remove($entity);
            $em->flush();  
        }

        $entity = $em->getRepository('App\Entity\Appexternal')->findoneby(["name"=>"Moodle"]);
        if(!$entity&&$activate_widmoodle) {
            $entity=new Appexternal;
            $entity->setName("Moodle");
            $em->persist($entity);
            $em->flush();
        }
        elseif($entity&&!$activate_widmoodle) {
            $em->remove($entity);
            $em->flush();  
        }

//== ICONE ===============================================================================================================================================
        $output->writeln('  > Creation Icons');

		$finder = new Finder();
        $finder->in('public/uploads/icon/');
        $finder->name('icon_*');
        foreach ($finder as $file) {
            $image="uploads/icon/".$file->getRelativePathname();
            $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>$image]);
            if(!$entityicon) {
                $entityicon = new Icon;
                $entityicon->setLabel($image);
                $em->persist($entityicon);
            }
        }
        $em->flush();

//== FLUX ================================================================================================================================================
        $output->writeln('  > Creation Flux');

        $entityFlux = $em->getRepository('App\Entity\Flux')->find(-2000);
        if(!$entityFlux&&($activate_widlimesurvey)) {
            $entityFlux = new Flux();
            $entityFlux->setRowOrder(0);
            $entityFlux->setColor("328637");
        }
        elseif($entityFlux&&!($activate_widlimesurvey)) {
            $em->remove($entityFlux);
            $em->flush();            
            $entityWidget=null;
        }
        if($entityFlux) {
            $entityFlux->setId(-2000);
            $entityFlux->setTitle("Limesurvey");
            $entityFlux->setUrl("/".$alias."feed/limesurvey/##userid##");
            $entityFlux->setMaxread(0);
            $em->persist($entityFlux);
            $em->flush();
        }

        $entityFlux = $em->getRepository('App\Entity\Flux')->find(-2010);
        if(!$entityFlux&&($activate_widmoodle)) {
            $entityFlux = new Flux();
            $entityFlux->setRowOrder(0);
            $entityFlux->setColor("f77f11");
        }
        elseif($entityFlux&&!($activate_widmoodle)) {
            $em->remove($entityFlux);
            $em->flush();            
            $entityWidget=null;
        }
        if($entityFlux) {
            $entityFlux->setId(-2010);
            $entityFlux->setTitle("Moodle");
            $entityFlux->setUrl("/".$alias."feed/moodle/##userid##");
            $entityFlux->setMaxread(0);
            $em->persist($entityFlux);
            $em->flush();
        }

//== PROJECTTASKTAG ===============================================================================================================================================
        $output->writeln('  > Creation Projecttasktag');

        $entityTag = $em->getRepository('App\Entity\Projecttasktag')->find(1);
        if(!$entityTag) {
            $entityTag = new Projecttasktag();
            $entityTag->setId(1);
            $entityTag->setName("Demande");
            $entityTag->setColor("1e824c");
            $em->persist($entityTag);
            $em->flush();
        }

        $entityTag = $em->getRepository('App\Entity\Projecttasktag')->find(2);
        if(!$entityTag) {
            $entityTag = new Projecttasktag();
            $entityTag->setId(2);
            $entityTag->setName("Evolution");
            $entityTag->setColor("2574a9");
            $em->persist($entityTag);
            $em->flush();
        }

        $entityTag = $em->getRepository('App\Entity\Projecttasktag')->find(3);
        if(!$entityTag) {
            $entityTag = new Projecttasktag();
            $entityTag->setId(3);
            $entityTag->setName("Anomalie");
            $entityTag->setColor("cf000f");
            $em->persist($entityTag);
            $em->flush();
        }

        $entityTag = $em->getRepository('App\Entity\Projecttasktag')->find(4);
        if(!$entityTag) {
            $entityTag = new Projecttasktag();
            $entityTag->setId(4);
            $entityTag->setName("Question");
            $entityTag->setColor("f15a22");
            $em->persist($entityTag);
            $em->flush();
        }

//== PROJECTTASKSTATUS ============================================================================================================================================
        $output->writeln('  > Creation Projecttaskstatus');

        $entityStatus = $em->getRepository('App\Entity\Projecttaskstatus')->find(10);
        if(!$entityStatus) {
            $entityStatus = new Projecttaskstatus();
            $entityStatus->setId(10);
            $entityStatus->setName("En Attente");
            $em->persist($entityStatus);
            $em->flush();
        }

        $entityStatus = $em->getRepository('App\Entity\Projecttaskstatus')->find(20);
        if(!$entityStatus) {
            $entityStatus = new Projecttaskstatus();
            $entityStatus->setId(20);
            $entityStatus->setName("A Faire");
            $em->persist($entityStatus);
            $em->flush();
        }

        $entityStatus = $em->getRepository('App\Entity\Projecttaskstatus')->find(30);
        if(!$entityStatus) {
            $entityStatus = new Projecttaskstatus();
            $entityStatus->setId(30);
            $entityStatus->setName("Fait");
            $em->persist($entityStatus);
            $em->flush();
        }

        $entityStatus = $em->getRepository('App\Entity\Projecttaskstatus')->find(40);
        if(!$entityStatus) {
            $entityStatus = new Projecttaskstatus();
            $entityStatus->setId(40);
            $entityStatus->setName("Livré");
            $em->persist($entityStatus);
            $em->flush();
        }

//== PAGECATEGORY ========================================================================================================================================
        $output->writeln('  > Creation Pagecategory');

        $entityPagecategory = $em->getRepository('App\Entity\Pagecategory')->find(-100);
        if(!$entityPagecategory) {
            $entityPagecategory = new Pagecategory();
            $entityPagecategory->setId(-100);
            $entityPagecategory->setName('Calendriers');
            $em->persist($entityPagecategory);
        }  

        $entityPagecategory = $em->getRepository('App\Entity\Pagecategory')->find(-90);
        if(!$entityPagecategory) {
            $entityPagecategory = new Pagecategory();
            $entityPagecategory->setId(-90);
            $entityPagecategory->setName('Blogs');
            $em->persist($entityPagecategory);
        } 

        $entityPagecategory = $em->getRepository('App\Entity\Pagecategory')->find(-80);
        if(!$entityPagecategory) {
            $entityPagecategory = new Pagecategory();
            $entityPagecategory->setId(-80);
            $entityPagecategory->setName('Projets');
            $em->persist($entityPagecategory);
        } 

        $entityPagecategory = $em->getRepository('App\Entity\Pagecategory')->find(1);
        if(!$entityPagecategory) {
            $entityPagecategory = new Pagecategory();
            $entityPagecategory->setId(1);
            $entityPagecategory->setName('URL');
            $em->persist($entityPagecategory);
        }         
        $entityPagecategory = $em->getRepository('App\Entity\Pagecategory')->find(2);
        if(!$entityPagecategory) {
            $entityPagecategory = new Pagecategory();
            $entityPagecategory->setId(2);
            $entityPagecategory->setName('Widget');
            $em->persist($entityPagecategory);
        }          
        $entityPagecategory = $em->getRepository('App\Entity\Pagecategory')->find(3);
        if(!$entityPagecategory) {
            $entityPagecategory = new Pagecategory();
            $entityPagecategory->setId(3);
            $entityPagecategory->setName('Editeur');
            $em->persist($entityPagecategory);
        }  


//== ALERTCATEGORY========================================================================================================================================
        $output->writeln('  > Creation Alert Category');

        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_megaphone2.png"]);
        $entityAlertcategoryapp = $em->getRepository('App\Entity\Alertcategory')->find(-100);
        if(!$entityAlertcategoryapp) {
            $entityAlertcategoryapp = new Alertcategory();
            $entityAlertcategoryapp->setId(-100);
            $entityAlertcategoryapp->setColor("00a996");
            $entityAlertcategoryapp->setLabel('Annonces');
            $entityAlertcategoryapp->setIcon($entityicon);
            $em->persist($entityAlertcategoryapp);
        }


//== ITEMCATEGORY========================================================================================================================================
        $output->writeln('  > Creation Item Category');

        $entityItemcategoryapp = $em->getRepository('App\Entity\Itemcategory')->find(-100);
        if(!$entityItemcategoryapp) {
            $entityItemcategoryapp = new Itemcategory();
            $entityItemcategoryapp->setId(-100);
            $entityItemcategoryapp->setRowOrder(0);
            $entityItemcategoryapp->setLabel('Applications');
            $em->persist($entityItemcategoryapp);
        }

        $entityItemcategoryadm = $em->getRepository('App\Entity\Itemcategory')->find(-99);
        if(!$entityItemcategoryadm) {
            $entityItemcategoryadm = new Itemcategory();
            $entityItemcategoryadm->setId(-99);
            $entityItemcategoryadm->setRowOrder(99);
            $entityItemcategoryadm->setLabel('Administration');
            $em->persist($entityItemcategoryadm);
        }        


//== ITEM ===============================================================================================================================================
        $output->writeln('  > Creation Item');
        $groupall=$em->getRepository('App\Entity\Group')->findOneBy(["fgall"=>true]);

        // Item Adminer
        if($activate_widadminer) {
            $widadminer_url =$this->container->getParameter('widadminer_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-394);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_adminer.png"]);

                $entityItem = new Item();
                $entityItem->setId(-394);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Adminer');
                $entityItem->setSubtitle("Gestionnaire de Bases de Données");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryadm);
                $entityItem->setEssential(true);
                $entityItem->setRoles(["ROLE_ADMIN"]);
            }
            $entityItem->setUrl($widadminer_url);
            $em->persist($entityItem);            
        }

        // Item Balado
        if($activate_widbalado) {
            $widbalado_url =$this->container->getParameter('widbalado_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-377);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_balado.png"]);

                $entityItem = new Item();
                $entityItem->setId(-377);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Balado');
                $entityItem->setSubtitle("Interactions orales et écrites en ligne avec possibilité d’enregistrement audio intégré");
                $entityItem->SetContent("Balad((o)) permet d’interagir avec les élèves en leur proposant une activité en ligne avec texte, image, audio déposé ou enregistré en ligne, vidéo déposée ou intégrée, documents joints.<br>Les élèves peuvent répondre en ligne avec texte, image, audio déposé ou enregistré en ligne, vidéo déposée ou intégrée, documents joints.<br>L’enseignant peut ensuite consulter en ligne les travaux rendus par les élèves, mais pas encore les annoter individuellement.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widbalado_url);
            $em->persist($entityItem);            
        }

        // Item CdT
        if($activate_widcdt) {
            $widcdt_url =$this->container->getParameter('widcdt_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-391);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_cdt.png"]);

                $entityItem = new Item();
                $entityItem->setId(-391);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('CdT');
                $entityItem->setSubtitle("Application complète de gestion de cahier de texte scolaire");
                $entityItem->SetContent("Application complète de gestion de cahier de texte scolaire");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widcdt_url);
            $em->persist($entityItem);            
        }

        // Item Dokuwiki
        if($activate_widdokuwiki) {
            $widdokuwiki_url =$this->container->getParameter('widdokuwiki_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-399);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_dokuwiki.png"]);

                $entityItem = new Item();
                $entityItem->setId(-399);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Dokuwiki');
                $entityItem->setSubtitle("Base de connaissances sous forme d’un wiki");
                $entityItem->SetContent("Le wiki permet de mettre du contenu classé par catégories.<br>Sur chaque catégorie et sur chaque page, des droits de lecture, modification, suppression peuvent être affectés à des utilisateurs ou des groupes d’utilisateurs.<br>En établissement, le wiki peut être utilisé comme base de connaissances en intranet / extranet professionnel ou comme support pédagogique d’écriture collaborative.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widdokuwiki_url);
            $em->persist($entityItem);            
        }

        // Item eConnect
        if($activate_wideconnect) {
            $wideconnect_url =$this->container->getParameter('wideconnect_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-376);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_econnect.png"]);

                $entityItem = new Item();
                $entityItem->setId(-376);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Econnect');
                $entityItem->setSubtitle("Gestion de connecteurs vers d'autres applications");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($wideconnect_url);
            $em->persist($entityItem);            
        }

        // Item EAD
        if($activate_widead) {
            $widead_url =$this->container->getParameter('widead_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-393);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_ead.png"]);

                $entityItem = new Item();
                $entityItem->setId(-393);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('EAD');
                $entityItem->setSubtitle("Console d'administration du serveur scribe");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryadm);
                $entityItem->setEssential(true);
                $entityItem->setRoles(["ROLE_ADMIN"]);
            }
            $entityItem->setUrl($widead_url);
            $em->persist($entityItem);            
        }

        // Item EOE
        if($activate_wideoe) {
            $wideoe_url =$this->container->getParameter('wideoe_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-370);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_eoe.png"]);

                $entityItem = new Item();
                $entityItem->setId(-370);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Outils Élève');
                $entityItem->setSubtitle("EOLE Outils Elève<br>(EOE)");
                $entityItem->setContent("EOLE Outils Élève (EOE) permet à l’élève en particulier de changer son mot de passe d’accès, dans l’objectif de maîtriser son identité numérique sur l’ENT.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($wideoe_url);
            $em->persist($entityItem);            
        }

        // Item EOP
        if($activate_wideop) {
            $wideop_url =$this->container->getParameter('wideop_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-371);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_eop.png"]);

                $entityItem = new Item();
                $entityItem->setId(-371);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Outils Professeur');
                $entityItem->setSubtitle("EOLE Outils Professeur<br>(EOP)");
                $entityItem->setContent("Parmi les outils disponibles dans EOLE Outils Professeur (EOP) :<br>Changement de mot de passe local (Scribe) utilisé sur les postes en établissement<br>Changer le mot de passe des élèves (uniquement pour les professeurs principaux)<br>Distribuer des documents / devoirs à des classes et groupes à l’aide du dossier « perso » de l’enseignant et de chaque élève. Cette application est adaptée à un fonctionnement synchrone en établissement, un peu moins en distanciel asynchrone.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($wideop_url);
            $em->persist($entityItem);            
        }

        // Item etherhome
        if($activate_widetherhome) {
            $widetherhome_url =$this->container->getParameter('widetherhome_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-382);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_etherhome.png"]);

                $entityItem = new Item();
                $entityItem->setId(-382);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Etherhome');
                $entityItem->setSubtitle("Accès aux pads, calcs et scrums");
                $entityItem->setContent("Etherhome permet de créer, partager et accéder aux pads (textes), calcs (tableaux) et scrums (murs de textes).<br>Les pads et calcs sont des supports de travail collaboratif synchrone ou asynchrone, à reprendre éventuellement ensuite dans un traitement de textes ou un tableur ou un logiciel de présentation.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widetherhome_url);
            $em->persist($entityItem);            
        }

        // Item fluxbb
        if($activate_widfluxbb) {
            $widfluxbb_url =$this->container->getParameter('widfluxbb_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-397);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_fluxbb.png"]);

                $entityItem = new Item();
                $entityItem->setId(-397);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Fluxbb');
                $entityItem->setSubtitle("Forum");
                $entityItem->setContent("Forum avec gestion des droits des utilisateurs.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widfluxbb_url);
            $em->persist($entityItem);            
        }

        // Item genconfig
        if($activate_widgenconfig) {
            $widgenconfig_url =$this->container->getParameter('widgenconfig_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-368);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_genconfig.png"]);

                $entityItem = new Item();
                $entityItem->setId(-368);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Genconfig');
                $entityItem->setSubtitle("Console de configuration du serveur");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryadm);
                $entityItem->setEssential(true);
                $entityItem->setRoles(["ROLE_ADMIN"]);
            }
            $entityItem->setUrl($widgenconfig_url);
            $em->persist($entityItem);            
        }

        // Item gepi
        if($activate_widgepi) {
            $widgepi_url =$this->container->getParameter('widgepi_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-389);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_gepi.png"]);

                $entityItem = new Item();
                $entityItem->setId(-389);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('GEPI');
                $entityItem->setSubtitle("Intégration du logiciel de gestion des notes, absences, cahier de texte");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widgepi_url);
            $em->persist($entityItem);            
        }

        // Item glpi
        if($activate_widglpi) {
            $widglpi_url =$this->container->getParameter('widglpi_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-388);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_glpi.png"]);

                $entityItem = new Item();
                $entityItem->setId(-388);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('GLPI');
                $entityItem->setSubtitle("Gestion de tickets");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widglpi_url);
            $em->persist($entityItem);            
        }

        // Item grr
        if($activate_widgrr) {
            $widgrr_url =$this->container->getParameter('widgrr_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-388);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_grr.png"]);

                $entityItem = new Item();
                $entityItem->setId(-388);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Grr');
                $entityItem->setSubtitle("Gestion et de Réservations de Ressources");
                $entityItem->setContent("GRR permet de réserver des ressources disponibles dans l’établissement : salles, matériels, etc.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widgrr_url);
            $em->persist($entityItem);            
        }

        // Item kanboard
        if($activate_widkanboard) {
            $widkanboard_url =$this->container->getParameter('widkanboard_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-363);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_kanboard.png"]);

                $entityItem = new Item();
                $entityItem->setId(-363);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Kanboard');
                $entityItem->setSubtitle("Gestion de rojets");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widkanboard_url);
            $em->persist($entityItem);            
        }

        // Item Limesurvey
        if($activate_widlimesurvey) {
            $widlimesurvey_url =$this->container->getParameter('widlimesurvey_url')."/admin";
            $entityItem = $em->getRepository('App\Entity\Item')->find(-374);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_limesurvey.png"]);

                $entityItem = new Item();
                $entityItem->setId(-374);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Limesurvey');
                $entityItem->setSubtitle("Gestion d’enquêtes");
                $entityItem->setContent("Limesurvey permet de créer des enquêtes en ligne avec différents formats de réponses : texte, nombre, choix multiple avec réponse unique ou non, etc.<br>Chaque enquête peut être adressée :<br>soit à des utilisateurs ou groupes par invitation individuelle, ce qui permet d’éviter les doubles réponses<br>soit de manière anonyme par un lien public");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widlimesurvey_url);
            $em->persist($entityItem);            
        }

        // Item Mindmaps
        if($activate_widmindmaps) {
            $widmindmaps_url =$this->container->getParameter('widmindmaps_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-369);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_mindmaps.png"]);

                $entityItem = new Item();
                $entityItem->setId(-369);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Mindmaps');
                $entityItem->setSubtitle("Carte Mentale");
                $entityItem->setContent("Carte mentale simple, enregistrable mais non collaborative.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widmindmaps_url);
            $em->persist($entityItem);            
        }

        // Item Moodle
        if($activate_widmoodle) {
            $widmoodle_url =$this->container->getParameter('widmoodle_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-387);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_moodle.png"]);

                $entityItem = new Item();
                $entityItem->setId(-387);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Moodle');
                $entityItem->setSubtitle("Cours en ligne");
                $entityItem->setContent("Plateforme d’apprentissage en ligne (« e-learning ») où l’enseignant peut mettre à disposition :<br>- des ressources à consulter : textes en ligne, documents joints, vidéos intégrées, etc.<br>- des activités : devoirs à rendre, tests auto-évalués, glossaire collaboratif, activités multimédia H5P, etc.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widmoodle_url);
            $em->persist($entityItem);            
        }        

        // Item Nextcloud
        if($activate_widnextcloud) {
            $widnextcloud_url =$this->container->getParameter('widnextcloud_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-366);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_nextcloud.png"]);

                $entityItem = new Item();
                $entityItem->setId(-366);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Nextcloud');
                $entityItem->setSubtitle("Dépôt et partage de fichiers");
                $entityItem->setContent("Nextcloud permet de déposer des fichiers, organisés dans des dossiers.<br>Ces dossiers et fichiers peuvent être partagés avec des droits de lecture et/ou de modification / suppression :<br>Soit avec des utilisateurs ou groupes d’utilisateurs<br>Soit de manière anonyme avec un lien public, paramétrable (durée, mot de passe)");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widnextcloud_url);
            $em->persist($entityItem);            
        } 

        // Item Nineboard
        if($activate_widnineboard) {
            $widnineboard_url =$this->container->getParameter('widnineboard_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-361);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_nineboard.png"]);

                $entityItem = new Item();
                $entityItem->setId(-361);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Nineboard');
                $entityItem->setSubtitle("Accès aux pads, calcs, scrums, whiteboards, timelines et mindmaps");
                $entityItem->setContent("Nineboard permet de créer, partager et accéder aux pads (textes), calcs (tableaux), scrums (murs de textes en colonne), whiteboards (murs de textes libre), timelines (frises temporelles) et mindmaps (cartes mentales)<br>Les pads et calcs sont des supports de travail collaboratif synchrone ou asynchrone, à reprendre éventuellement ensuite dans un traitement de textes ou un tableur ou un logiciel de présentation.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widnineboard_url);
            $em->persist($entityItem);            
        }

        // Item Nineschool
        if($activate_widnineschool) {
            $widnineschool_url =$this->container->getParameter('widnineschool_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-1001);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_nineschool.png"]);

                $entityItem = new Item();
                $entityItem->setId(-1001);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Nineschool');
                $entityItem->setSubtitle("Gestionnaire d'activités scolaire'");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widnineschool_url);
            $em->persist($entityItem);            
        }

        // Item Ninesurvey
        if($activate_widninesurvey) {
            $widninesurvey_url =$this->container->getParameter('widninesurvey_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-1002);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_ninesurvey.png"]);

                $entityItem = new Item();
                $entityItem->setId(-1002);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Ninesurvey');
                $entityItem->setSubtitle("Application de Sondage par Date");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widninesurvey_url);
            $em->persist($entityItem);            
        }

        // Item Onlyoffice
        if($activate_widonlyoffice) {
            $widonlyoffice_url =$this->container->getParameter('widonlyoffice_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-1000);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_onlyoffice.png"]);

                $entityItem = new Item();
                $entityItem->setId(-1000);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Onlyoffice');
                $entityItem->setSubtitle("Application Bureautique");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widonlyoffice_url);
            $em->persist($entityItem);            
        } 

        // Item Opensondage
        if($activate_widopensondage) {
            $widopensondage_url =$this->container->getParameter('widopensondage_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-383);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_opensondage.png"]);

                $entityItem = new Item();
                $entityItem->setId(-383);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Opensondage');
                $entityItem->setSubtitle("Création de sondage à réponse simple ou pour le choix d’une date");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widopensondage_url);
            $em->persist($entityItem);            
        }  

        // Item phpLdapAdmin
        if($activate_widphpldapadmin) {
            $widphpldapadmin_url =$this->container->getParameter('widphpldapadmin_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-362);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_phpldapadmin.png"]);

                $entityItem = new Item();
                $entityItem->setId(-362);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('PhpLdapAdmin');
                $entityItem->setSubtitle("Gestionnaire d’annuaire LDAP");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryadm);
                $entityItem->setEssential(true);
                $entityItem->setRoles(["ROLE_ADMIN"]);
            }
            $entityItem->setUrl($widphpldapadmin_url);
            $em->persist($entityItem);            
        }  

        // Item Piwigo
        if($activate_widpiwigo) {
            $widpiwigo_url =$this->container->getParameter('widpiwigo_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-396);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_piwigo.png"]);

                $entityItem = new Item();
                $entityItem->setId(-396);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Piwigo');
                $entityItem->setSubtitle("Gestionnaire d’albums photos");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widpiwigo_url);
            $em->persist($entityItem);            
        }  

        // Item Piwik
        if($activate_widpiwik) {
            $widpiwik_url =$this->container->getParameter('widpiwik_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-380);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_piwik.png"]);

                $entityItem = new Item();
                $entityItem->setId(-380);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Piwik');
                $entityItem->setSubtitle("Mesures d’audience du portail");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryadm);
                $entityItem->setEssential(true);
                $entityItem->setRoles(["ROLE_ADMIN"]);
            }
            $entityItem->setUrl($widpiwik_url);
            $em->persist($entityItem);            
        } 

        // Item Roundcube
        if($activate_widroundcube) {
            $widroundcube_url =$this->container->getParameter('widroundcube_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-398);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_roundcube.png"]);

                $entityItem = new Item();
                $entityItem->setId(-398);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Roundcube');
                $entityItem->setSubtitle("Messagerie");
                $entityItem->setContent("Messagerie permettant la communication sécurisée par méls. La messagerie n’a pas pour but d’envoyer des gros fichiers mais plutôt de communiquer des informations, des liens.");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widroundcube_url);

            if($this->container->getParameter('cas_type')=="proxy")
                $entityItem->setBadgeurl("/ninegate/cas/imapunread");
            else
                $entityItem->setBadgeurl(null);
                
            $em->persist($entityItem);            
        } 

        // Item Sacoche
        if($activate_widsacoche) {
            $widsacoche_url =$this->container->getParameter('widsacoche_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-372);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_sacoche.png"]);

                $entityItem = new Item();
                $entityItem->setId(-372);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Sacoche');
                $entityItem->setSubtitle("Evaluation de compétences");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widsacoche_url);
            $em->persist($entityItem);            
        } 

        // Item Wordpress
        if($activate_widwordpress) {
            $widwordpress_url =$this->container->getParameter('widwordpress_url');
            $entityItem = $em->getRepository('App\Entity\Item')->find(-400);
            if(!$entityItem) {
                $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_wordpress.png"]);

                $entityItem = new Item();
                $entityItem->setId(-400);
                $entityItem->setRowOrder(0);
                $entityItem->setTitle('Wordpress');
                $entityItem->setSubtitle("Sites ou blogs en intranet ou sur internet");
                $entityItem->setContent("Avec la plateforme Wordpress, sur demande, un administrateur peut créer des blogs ou sites.<br>Pour chaque blog ou site, des droits peuvent être donnés aux utilisateurs  :<br>Qui peut écrire des articles ?<br>Qui peut valider ces articles ?<br>Qui peut consulter ces articles ? (le blog peut aussi être rendu visible publiquement sur internet)<br>");
                $entityItem->setIcon($entityicon);
                $entityItem->setTarget("_blank");
                $entityItem->setItemcategory($entityItemcategoryapp);
                $entityItem->setEssential(true);
                $entityItem->addGroup($groupall);
            }
            $entityItem->setUrl($widwordpress_url);
            $em->persist($entityItem);            
        }   
        
        
//== WIDGET ============================================================================================================================================
        $output->writeln('  > Creation Widget');

        // Widget Page web
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-2000);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_ribbon.png"]);
        $entityWidget->setId(-2000);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Page web');
        $entityWidget->setDescription("Affiche le contenu d'une page web");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_url");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(false);
        $entityWidget->setBorder(true);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "url", "loc": "col1", "type": "string", "label": "URL", "value": "", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Bureau
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1990);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_computer.png"]);
        $entityWidget->setId(-1990);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Bureau');
        $entityWidget->setDescription("Affiche vos items de bureau");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_item");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "modedesktop", "loc": "col1", "type": "desktopmode", "label": "Mode Affichage", "value": "2", "mandatory": "true"},{"id": "withbookmark", "loc": "col1", "type": "withbookmark", "label": "Avec Favoris", "value": "0", "mandatory": "true"},{"id": "itemcategory", "loc": "col1", "type": "itemcategory", "label": "Catégorie Affichée", "value": "", "mandatory": "false"},{"id": "search", "loc": "col4", "type": "boolean", "label": "Zone de Recherche", "value": "0", "mandatory": "true"},{"id": "menu", "loc": "col4", "type": "boolean", "label": "Menu des Catégories", "value": "0", "mandatory": "true"},{"id": "menuall", "loc": "col4", "type": "boolean", "label": "Menu toutes les Catégories", "value": "1", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Annonce
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1980);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_megaphone.png"]);
        $entityWidget->setId(-1980);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Annonces');
        $entityWidget->setDescription("Affiche vos annonces");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_alert");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "alertcategory", "loc": "col1", "type": "alertcategory", "label": "Catégorie Affichée", "value": "", "mandatory": "false"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Flux
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1970);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_rss.png"]);
        $entityWidget->setId(-1970);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Flux');
        $entityWidget->setDescription("Affiche vos flux RSS");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_flux");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "modelist", "loc": "col1", "type": "modelist", "label": "Mode Affichage", "value": "0", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Liens
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1960);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_star.png"]);
        $entityWidget->setId(-1960);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Liens');
        $entityWidget->setDescription("Bibliothèque de Liens");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_bookmark");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "modedesktop", "loc": "col1", "type": "desktopmode", "label": "Mode Affichage", "value": "2", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Lien
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1950);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_bolt.png"]);
        $entityWidget->setId(-1950);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Lien');
        $entityWidget->setDescription("Création d'un Lien unique");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_link");
        $entityWidget->setHeight("200");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(true);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "url", "loc": "col1", "type": "string", "label": "URL", "value": "", "mandatory": "true"},{"id": "target", "loc": "col1", "type": "target", "label": "Ouvrir le lien dans", "value": "0", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Texte
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1940);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_compose.png"]);
        $entityWidget->setId(-1940);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Texte');
        $entityWidget->setDescription("Votre propre texte à éditer");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_editor");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(true);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "html", "loc": "col5", "type": "ckeditor", "label": "Texte", "value": "", "mandatory": "false"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Carrousel
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1930);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_easel.png"]);
        $entityWidget->setId(-1930);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Carrousel');
        $entityWidget->setDescription("Carrousel d'images");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_slide");
        $entityWidget->setHeight("400");
        $entityWidget->setAutoajust(false);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "interval", "loc": "col1", "type": "integer", "label": "Interval en seconde entre 2 images", "value": "5", "mandatory": "false"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget File
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1920);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_folder.png"]);
        $entityWidget->setId(-1920);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Fichiers');
        $entityWidget->setDescription("Répertoire de fichiers");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_file");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(true);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "modelist", "loc": "col1", "type": "modelist", "label": "Mode Affichage", "value": "0", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Galery
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1910);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_image.png"]);
        $entityWidget->setId(-1910);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Galerie');
        $entityWidget->setDescription("Galerie d'images");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_galery");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": []}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Calendrier
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1900);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_calendar.png"]);
        $entityWidget->setId(-1900);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Calendrier');
        $entityWidget->setDescription("Calendrier d'évènements");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_calendar");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(true);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "nbday", "loc": "col1", "type": "integer", "label": "Nombre de jours affichés", "value": "15", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);

        // Widget Blog
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1890);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_rocket.png"]);
        $entityWidget->setId(-1890);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Blog');
        $entityWidget->setDescription("Les derniers articles publiés sur vos blogs");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_blog");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "nbarticle", "loc": "col1", "type": "integer", "label": "Nombre d\'articles affichés", "value": "10", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget RSS
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1880);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_rss.png"]);
        $entityWidget->setId(-1880);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('RSS');
        $entityWidget->setDescription("Afficher un flux RSS spécifique");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_rss");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "url", "loc": "col1", "type": "string", "label": "URL du Flux RSS", "value": "", "mandatory": "true"},{"id": "nbarticle", "loc": "col1", "type": "integer", "label": "Nombre d\'articles affichés (0 pour tout)", "value": "10", "mandatory": "true"},{"id": "modelist", "loc": "col1", "type": "modelist", "label": "Mode Affichage", "value": "0", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Applications Externe
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1870);
        if(!$entityWidget&&($activate_widlimesurvey||$activate_widmoodle)) $entityWidget = new Widget();
        elseif($entityWidget&&!($activate_widlimesurvey||$activate_widmoodle)) {
            $pagewidgets=$entityWidget->getPagewidgets();
            foreach($pagewidgets as $pagewidget) {
                $em->remove($pagewidget);
                $em->flush(); 
            }
            $em->remove($entityWidget);
            $em->flush();            
            $entityWidget=null;
        }
        if($entityWidget) {
            $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_frames.png"]);
            $entityWidget->setId(-1870);
            $entityWidget->setRoworder(0);
            $entityWidget->setIcon($entityicon);
            $entityWidget->setName('Mes Formulaires');
            $entityWidget->setDescription("Afficher vos formulaires provenant de vos applications");
            $entityWidget->setRouteview("app_portal_config_panelwidget_view_appexternal");
            $entityWidget->setHeight("630");
            $entityWidget->setAutoajust(true);
            $entityWidget->setBorder(false);
            $entityWidget->setOpened(true);
            $entityWidget->setAccess(["config","user","group"]);

            $parameter = json_decode('{"fields": [{"id": "modedesktop", "loc": "col1", "type": "desktopmode", "label": "Mode Affichage", "value": "2", "mandatory": "true"},{"id": "appexternal", "loc": "col1", "type": "appexternal", "label": "Applications à affichier", "value": "", "mandatory": "false"}]}');
            $entityWidget->setParameter($parameter);
            $em->persist($entityWidget);
        }

        // Widget Informations
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1860);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_info.png"]);
        $entityWidget->setId(-1860);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Informations');
        $entityWidget->setDescription("Afficher les informations associées à la page");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_info");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(true);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": []}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);

        // Widget Bureau Essentiel
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1850);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_computer.png"]);
        $entityWidget->setId(-1850);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Bureau Essentiel');
        $entityWidget->setDescription("Affiche les items de bureau essentiel");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_itemessential");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "modedesktop", "loc": "col1", "type": "desktopmode", "label": "Mode Affichage", "value": "2", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);


        // Widget Chat
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1840);
        if($activate_websocket) {
            if(!$entityWidget) $entityWidget = new Widget();
            $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_chat.png"]);
            $entityWidget->setId(-1840);
            $entityWidget->setRoworder(0);
            $entityWidget->setIcon($entityicon);
            $entityWidget->setName('Chat');
            $entityWidget->setDescription("Conversation instantanée");
            $entityWidget->setRouteview("app_portal_config_panelwidget_view_chat");
            $entityWidget->setHeight("1000");
            $entityWidget->setAutoajust(true);
            $entityWidget->setBorder(false);
            $entityWidget->setOpened(true);
            $entityWidget->setAccess(["config","group"]);
            $parameter = json_decode('{"fields": []}');
            $entityWidget->setParameter($parameter);
            $em->persist($entityWidget);
        }
        elseif($entityWidget) {
            $em->remove($entityWidget);
        }

        // Widget Mes Groupes
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1830);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_users.png"]);
        $entityWidget->setId(-1830);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Mes Groupes de Travail');
        $entityWidget->setDescription("Affiche la liste de vos groupes de travail");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_group");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(true);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": []}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);        

        // Actualités des groupes
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1820);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_megaphone2.png"]);
        $entityWidget->setId(-1820);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Actualités de mes Groupes');
        $entityWidget->setDescription("Affiche la liste actualités de vos groupes de travail");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_groupmessage");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "nbarticle", "loc": "col1", "type": "integer", "label": "Nombre d\'actualitées affichées (0 pour tout)", "value": "5", "mandatory": "true"},{"id": "modelist", "loc": "col1", "type": "modelist", "label": "Mode Affichage", "value": "1", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget); 

        // Onlyoffice document
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1810);
        if($widonlyoffice_sync)  {
            if(!$entityWidget) $entityWidget = new Widget();
            $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_onlyoffice.png"]);
            $entityWidget->setId(-1810);
            $entityWidget->setRoworder(0);
            $entityWidget->setIcon($entityicon);
            $entityWidget->setName('Onlyoffice');
            $entityWidget->setDescription("Les documents associés à votre groupe");
            $entityWidget->setRouteview("app_portal_config_panelwidget_view_onlydoc");
            $entityWidget->setHeight("630");
            $entityWidget->setAutoajust(true);
            $entityWidget->setBorder(true);
            $entityWidget->setOpened(true);
            $entityWidget->setAccess(["config","group"]);
            $parameter = json_decode('{"fields": [{"id": "apponly", "loc": "col1", "type": "apponly", "label": "Afficher", "value": "0", "mandatory": "true"},{"id": "modelist", "loc": "col1", "type": "modelist", "label": "Mode Affichage", "value": "0", "mandatory": "true"}]}');
            $entityWidget->setParameter($parameter);
            $em->persist($entityWidget); 
        }
        elseif($entityWidget) {
            $em->remove($entityWidget);
        }        

        // Widget Tâche
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1800);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_check.png"]);
        $entityWidget->setId(-1800);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Tâche');
        $entityWidget->setDescription("Gestion de projet par tâches");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_project");
        $entityWidget->setHeight("630");
        $entityWidget->setAutoajust(true);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": []}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);

        // Roundcube
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1790);
        if($activate_widroundcube)  {
            if(!$entityWidget) $entityWidget = new Widget();
            $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_roundcube.png"]);
            $entityWidget->setId(-1790);
            $entityWidget->setRoworder(0);
            $entityWidget->setIcon($entityicon);
            $entityWidget->setName('Roundcube');
            $entityWidget->setDescription("Webmail");
            $entityWidget->setRouteview("app_portal_config_panelwidget_view_urlfixe");
            $entityWidget->setHeight("630");
            $entityWidget->setAutoajust(false);
            $entityWidget->setBorder(true);
            $entityWidget->setOpened(true);
            $entityWidget->setAccess(["config","user","group"]);
            $parameter = json_decode('{"fields": [{"id": "url", "loc": "col1", "type": "hidden", "label": "URL", "value": "'.$widroundcube_url.'", "mandatory": "true"}]}');
            $entityWidget->setParameter($parameter);
            $em->persist($entityWidget); 
        }
        elseif($entityWidget) {
            $em->remove($entityWidget);
        } 

        // Dokuwiki
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1780);
        if($activate_widdokuwiki)  {
            if(!$entityWidget) $entityWidget = new Widget();
            $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_dokuwiki.png"]);
            $entityWidget->setId(-1780);
            $entityWidget->setRoworder(0);
            $entityWidget->setIcon($entityicon);
            $entityWidget->setName('Dokuwiki');
            $entityWidget->setDescription("Plan de votre dokuwiki");
            $entityWidget->setRouteview("app_portal_config_panelwidget_view_urlfixe");
            $entityWidget->setHeight("630");
            $entityWidget->setAutoajust(false);
            $entityWidget->setBorder(false);
            $entityWidget->setOpened(true);
            $entityWidget->setAccess(["config","user","group"]);
            $parameter = json_decode('{"fields": [{"id": "url", "loc": "col1", "type": "hidden", "label": "URL", "value": "'.$widdokuwiki_url.'/widgetdokuwiki.php", "mandatory": "true"}]}');
            $entityWidget->setParameter($parameter);
            $em->persist($entityWidget); 
        }
        elseif($entityWidget) {
            $em->remove($entityWidget);
        } 

        // Widget Séparateur
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1600);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_roadblock.png"]);
        $entityWidget->setId(-1600);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Séparateur');
        $entityWidget->setDescription("Widget graphique pour séparer les autres widgets");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_separator");
        $entityWidget->setHeight("50");
        $entityWidget->setAutoajust(false);
        $entityWidget->setBorder(false);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $entityWidget->setColorbodyback("ffffff");
        $parameter = json_decode('{"fields": [{"id": "seetitle", "loc": "col1", "type": "boolean", "label": "Afficher le titre", "value": "0", "mandatory": "true"},{"id": "seeicon", "loc": "col1", "type": "boolean", "label": "Afficher l\'icône", "value": "0", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);

        // Widget Horloge
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1500);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_clock.png"]);
        $entityWidget->setId(-1500);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Horloge');
        $entityWidget->setDescription("Une simple horloge");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_clock");
        $entityWidget->setHeight("250");
        $entityWidget->setAutoajust(false);
        $entityWidget->setBorder(true);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": [{"id": "clock", "loc": "col1", "type": "clock", "label": "Mode d\'affichage", "value": "0", "mandatory": "true"}]}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);

        // Widget Calculatrice
        $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1490);
        if(!$entityWidget) $entityWidget = new Widget();
        $entityicon = $em->getRepository('App\Entity\Icon')->findoneby(["label"=>"uploads/icon/icon_calculator.png"]);
        $entityWidget->setId(-1490);
        $entityWidget->setRoworder(0);
        $entityWidget->setIcon($entityicon);
        $entityWidget->setName('Calculatrice');
        $entityWidget->setDescription("Une simple calculatrice");
        $entityWidget->setRouteview("app_portal_config_panelwidget_view_calculator");
        $entityWidget->setHeight("400");
        $entityWidget->setAutoajust(false);
        $entityWidget->setBorder(true);
        $entityWidget->setOpened(true);
        $entityWidget->setAccess(["config","user","group"]);
        $parameter = json_decode('{"fields": []}');
        $entityWidget->setParameter($parameter);
        $em->persist($entityWidget);

        // flush
        $em->flush();
        

//== PAGETEMPALTE =======================================================================================================================================
        $output->writeln('  > Creation Pagetemplate');

        // Template app
        $entityPage = $em->getRepository('App\Entity\Page')->find(-100);
        if(!$entityPage) {
            $entityPagecategory = $em->getRepository('App\Entity\Pagecategory')->find(2);
            $entityGroup = $em->getRepository('App\Entity\Group')->findOneBy(["fgall"=>true]);

            $entityPage = new Page();
            $entityPage->setId(-100);
            $entityPage->setRowOrder(0);
            $entityPage->setName('Applications');
            $entityPage->setParentfor('app');
            $entityPage->setMaxwidth(1000);
            $entityPage->getFgpreference(true);
            $entityPage->setPagecategory($entityPagecategory);
            $entityPage->addGroup($entityGroup);
            $entityPage->setTemplate('{"rows":[{"id":0,"cols":[{"id":0,"size": 12,"rows":[]}]}]}');

            $em->persist($entityPage);
            $em->flush();

            $entityPagewidget = $em->getRepository('App\Entity\Pagewidget')->find(-110);    
            if(!$entityPagewidget) {
                $entityWidget = $em->getRepository('App\Entity\Widget')->find(-1990); 

                $entityPagewidget = new Pagewidget();
                $entityPagewidget->setId(-110);
                $entityPagewidget->setLoc("R1C1");
                $entityPagewidget->setRoworder(0);
                $entityPagewidget->setName("Applications");
                $entityPagewidget->setHeight($entityWidget->getHeight());
                $entityPagewidget->setAutoajust($entityWidget->getAutoajust());
                $entityPagewidget->setBorder($entityWidget->getBorder());
                $entityPagewidget->setOpened($entityWidget->getOpened());
                $entityPagewidget->setIcon($entityWidget->getIcon());
                $entityPagewidget->setPage($entityPage);
                $entityPagewidget->setWidget($entityWidget);

                $param["fields"]=["fields"=>[["id"=>"modedesktop","value"=>2],["id"=>"withbookmark","value"=>0],["id"=>"itemcategory","value"=>null],["id"=>"menu","value"=>1],["id"=>"search","value"=>1],["id"=>"menuall","value"=>1]]];
                $entityPagewidget->setParameter($param["fields"]);

                $em->persist($entityPagewidget);
                $em->flush();
            }
        }  

        // Template Group
        $entityPage = $em->getRepository('App\Entity\Page')->find(-110);
        if(!$entityPage) {
            $entityPagecategory = $em->getRepository('App\Entity\Pagecategory')->find(2);
            $entityPage = new Page();
            $entityPage->setId(-110);
            $entityPage->setRowOrder(0);
            $entityPage->setName('Accueil Groupe');
            $entityPage->setParentfor('group');
            $entityPage->setMaxwidth(0);
            $entityPage->setPagecategory($entityPagecategory);
            $entityPage->setTemplate('{"rows":[{"id":0,"cols":[{"id":0,"size": 3,"rows":[]},{"id":1,"size": 6,"rows":[{"id":0,"cols":[{"id":0,"size": 6},{"id":1,"size": 6}]}]},{"id":2,"size": 3,"rows":[]}]}]}');

            $em->persist($entityPage);
            $em->flush();

            // Widget Nos Liens
            $fields=["fields"=>[["id"=>"modedesktop","value"=>2]]];
            $this->addWidget(-120,$entityPage,-1960,"R1C2R1C1",0,"Nos Liens",true,$fields);

            // Widget Nos Fichiers
            $fields=["fields"=>[]];
            $this->addWidget(-130,$entityPage,-1920,"R1C2R1C2",0,"Nos Fichiers",true,$fields);

            // Widget Info Page
            $fields=["fields"=>[]];
            $this->addWidget(-140,$entityPage,-1860,"R1C1",0,"Information Page",true,$fields);  

            // Widget Tâche
            $fields=["fields"=>[]];
            $this->addWidget(-145,$entityPage,-1800,"R1C1",1,"Taches du groupe",true,$fields);  

            // Widget Notre Blog
            $fields=["fields"=>[["id"=>"nbarticle","value"=>5]]];
            $this->addWidget(-150,$entityPage,-1890,"R1C2",0,"Notre Blog",false,$fields);      

            // Widget Notre Calendrier
            $fields=["fields"=>[["id"=>"nbday","value"=>30]]];
            $this->addWidget(-160,$entityPage,-1900,"R1C2R1C1",1,"Notre Calendrier",true,$fields);         
            
            // Chat
            $fields=["fields"=>[]];
            $this->addWidget(-170,$entityPage,-1840,"R1C3",0,"Chat",false,$fields);              
        } 

        // Template Accueil
        $entityPage = $em->getRepository('App\Entity\Page')->find(-200);
        if(!$entityPage) {
            $entityPagecategory = $em->getRepository('App\Entity\Pagecategory')->find(2);
            $entityPage = new Page();
            $entityPage->setId(-200);
            $entityPage->setRowOrder(0);
            $entityPage->setName('Accueil');
            $entityPage->setMaxwidth(1200);
            $entityPage->setPagecategory($entityPagecategory);
            $entityPage->setTemplate('{"rows":[{"id":0,"cols":[{"id":0,"size": 8,"rows":[{"id":0,"cols":[{"id":0,"size": 12}]},{"id":1,"cols":[{"id":0,"size": 6},{"id":1,"size": 6}]}]},{"id":1,"size": 4,"rows":[]}]}]}');
            $entityPage->addGroup($groupall);

            $em->persist($entityPage);
            $em->flush();

            // Widget Bureau Essentiel
            $fields=["fields"=>[["id"=>"modedesktop","value"=>2]]];
            $this->addWidget(-200,$entityPage,-1850,"R1C1R1C1",0,"Bureau Essentiel",false,$fields); 
            
            // Widget Blog
            $fields=["fields"=>[["id"=>"nbarticle","value"=>5]]];
            $this->addWidget(-210,$entityPage,-1890,"R1C1R2C1",0,"Blog",false,$fields);             

            // Widget Flux
            $fields=["fields"=>[["id"=>"modelist","value"=>0]]];
            $this->addWidget(-220,$entityPage,-1970,"R1C1R2C2",0,"Flux",false,$fields);              

            // Widget Annonce
            $fields=["fields"=>[["id"=>"alertcategory","value"=>null]]];
            $this->addWidget(-230,$entityPage,-1980,"R1C2",0,"Annonces",false,$fields);              

            // Widget Mes Groupes de Travail
            $fields=["fields"=>[]];
            $this->addWidget(-240,$entityPage,-1830,"R1C2",1,"Mes Groupes",false,$fields);              

            // Widget Actualités de mes Groupes
            $fields=["fields"=>[["id"=>"nbarticle","value"=>1],["id"=>"modelist","value"=>1]]];
            $this->addWidget(-250,$entityPage,-1820,"R1C2",2,"Actualités de mes Groupes",false,$fields);              

            // Widget Calendrier
            $fields=["fields"=>[["id"=>"nbday","value"=>30]]];
            $this->addWidget(-260,$entityPage,-1900,"R1C2",3,"Calendrier",true,$fields);             
        } 

        $output->writeln('');

        // CRON
        $cron_activate = $this->container->getParameter('cron_activate');
        if(!$cron_activate)
            return Command::SUCCESS;
        $output->writeln('CRON = Default Data');
        $this->insertCron();
        $output->writeln('');

        return Command::SUCCESS;
    }

    protected function addModeration($profil,$route,$visible) {
        $em = $this->em;
        $entity=$em->getRepository('App\Entity\PermModo')->findOneBy(["route"=>$route,"permmodoprofil"=>$profil]);
        if(!$entity) {
            $entity=new PermModo();
            $entity->setRoute($route);
            $entity->setVisible($visible);
            $entity->setPermmodoprofil($profil);
            $em->persist($entity);
            $em->flush();            
        }
    }

    protected function insertCron() {

        // On s'assure qu'il n'y a pas de tache cron en trop
        $purgecrons=$this->em->getRepository('App\Entity\Cron')->findAll();
        foreach($purgecrons as $purge) {
            if($purge->getId() > 2000) {
                $this->em->remove($purge);
            }
        }
        $this->em->flush();

        // On initialise les jobs cron
        $metadata =  $this->em->getClassMetaData('App\Entity\Cron');
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        // Job synchronisation des comptes utilisateur
        // Toute les 24h à 3h00
        $entity = $this->em->getRepository('App\Entity\Cron')->find(100);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(3,0);            
            $entity->setCommand("app:Synchro");
            $entity->setDescription("Synchronisation des Comptes Utilisateurs");
            $entity->setId(100);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $entity->setJsonargument('{"simulate":"false"}');
            $this->em->persist($entity);
        }

        // Job synchronisation onlyoffice
        // Toute les 1h // Désactivé par défaut
        $widonlyoffice_sync = $this->container->getParameter('widonlyoffice_sync');
        $entity = $this->em->getRepository('App\Entity\Cron')->find(105);
        if(!$entity&&$widonlyoffice_sync) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();          
            $entity->setCommand("app:Only");
            $entity->setDescription("Synchronisation des Only Office");
            $entity->setId(105);
            $entity->setStatut(4);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(3600);
            $entity->setNextexecdate($entity->getSubmitdate());
            $entity->setJsonargument('{"simulate":"false"}');
            $this->em->persist($entity);
        }
        elseif($entity&&!$widonlyoffice_sync) {
            $this->em->remove($entity);
        }

        // Job purge des registrations obsolètes
        // Toute les 5mn
        $entity = $this->em->getRepository('App\Entity\Cron')->find(110);
        if(!$entity) {
            $entity = new Cron;
            $entity->setCommand("app:PurgeRegistration");
            $entity->setDescription("Purge des Inscriptions obsolètes");
            $entity->setId(110);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(300);
            $entity->setNextexecdate($entity->getSubmitdate());
            $this->em->persist($entity);
        }

        // Job de purge des fichiers obsolète
        // Toute les 24h à 3h00
        $entity = $this->em->getRepository('App\Entity\Cron')->find(200);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(3,0);            
            $entity->setCommand("app:PurgeFile");
            $entity->setDescription("Suppression des fichiers obsolètes");
            $entity->setId(200);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $this->em->persist($entity);
        }

        // Job Statistic
        // Toute les 24h à 23h30
        $entity = $this->em->getRepository('App\Entity\Cron')->find(210);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(23,30);            
            $entity->setCommand("app:Statistic");
            $entity->setDescription("Cacul des indicateurs d'usages");
            $entity->setId(210);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $this->em->persist($entity);
        }

        // Job Dump
        // Toute les 24h à 2h00
        $entity = $this->em->getRepository('App\Entity\Cron')->find(220);
        if(!$entity) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(2,0);            
            $entity->setCommand("app:Dump");
            $entity->setDescription("Sauvegarde de la BDD");
            $entity->setId(220);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $this->em->persist($entity);
        }

        // CRON PORTAIL
        // Job purge des registrations obsolètes
        // Toute les 5mn
        $portal_activate = $this->container->getParameter('portal_activate');
        $calendar_activate = $this->container->getParameter('calendar_activate');
        $entity = $this->em->getRepository('App\Entity\Cron')->find(1000);
        if(!$entity&&($portal_activate||$calendar_activate)) {
            $entity = new Cron;
            $entity->setCommand("app:SynchroICS");
            $entity->setDescription("Synchronisation des Calendriers Utilisateurs liés à une URL ICS");
            $entity->setId(1000);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(600);
            $entity->setNextexecdate($entity->getSubmitdate());
            $this->em->persist($entity);
        }
        elseif($entity&&!($portal_activate||$calendar_activate)) {
            $this->em->remove($entity);
        }
        // Job de récupération des sondages Limesurvey
        // Toute les 6h 
        $activate_widlimesurvey = $this->container->getParameter('activate_widlimesurvey');
        $entity = $this->em->getRepository('App\Entity\Cron')->find(1010);
        if(!$entity&&$activate_widlimesurvey) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(1,0);            
            $entity->setCommand("app:GetLimesurvey");
            $entity->setDescription("Récupération des sondages Limesurvey");
            $entity->setId(1010);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(21600);
            $entity->setNextexecdate($nextdate);
            $this->em->persist($entity);
        }
        elseif($entity&&!$activate_widlimesurvey) {
            $this->em->remove($entity);
        }
        // Job de récupération des cours Moodle
        // Toute les 6h 
        $activate_widmoodle = $this->container->getParameter('activate_widmoodle');
        $entity = $this->em->getRepository('App\Entity\Cron')->find(1020);
        if(!$entity&&$activate_widmoodle) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(1,0);            
            $entity->setCommand("app:GetMoodle");
            $entity->setDescription("Récupération des cours Moodle ");
            $entity->setId(1020);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(21600);
            $entity->setNextexecdate($nextdate);
            $this->em->persist($entity);
        }
        elseif($entity&&!$activate_widmoodle) {
            $this->em->remove($entity);
        }

        // Job notification message non lus 
        // Toute les 24h à 5h00
        $websocket_activate = $this->container->getParameter('websocket_activate');
        $entity = $this->em->getRepository('App\Entity\Cron')->find(2000);
        if(!$entity&&($portal_activate||$calendar_activate)) {
            $entity = new Cron;
            $nextdate=$entity->getSubmitdate();
            $nextdate->setTime(5,0);            
            $entity->setCommand("app:NotifMessage");
            $entity->setDescription("Notifier les utilisateurs des messages non lus");
            $entity->setId(2000);
            $entity->setStatut(2);
            $entity->setRepeatcall(0);
            $entity->setRepeatexec(0);
            $entity->setRepeatinterval(86400);
            $entity->setNextexecdate($nextdate);
            $this->em->persist($entity);            
        }
        elseif($entity&&!($websocket_activate)) {
            $this->em->remove($entity);
        }

        // On flush
        $this->em->flush();
    } 
    

    private function addWidget($id,$entityPage,$widgetid,$loc,$order,$title,$border,$fields) {
        $em = $this->em;

        $entityPagewidget = $em->getRepository('App\Entity\Pagewidget')->find($id);    
        if(!$entityPagewidget) {
            $entityWidget = $em->getRepository('App\Entity\Widget')->find($widgetid); 

            if($entityWidget) {
                $entityPagewidget = new Pagewidget();
                $entityPagewidget->setId($id);
                $entityPagewidget->setLoc($loc);
                $entityPagewidget->setRoworder($order);
                $entityPagewidget->setName($title);
                $entityPagewidget->setHeight($entityWidget->getHeight());
                $entityPagewidget->setAutoajust($entityWidget->getAutoajust());
                $entityPagewidget->setBorder($border);
                $entityPagewidget->setOpened($entityWidget->getOpened());
                $entityPagewidget->setIcon($entityWidget->getIcon());
                $entityPagewidget->setPage($entityPage);
                $entityPagewidget->setWidget($entityWidget);
                $entityPagewidget->setParameter($fields);
                $em->persist($entityPagewidget);
                $em->flush();
            }
        }        

    }     
}
