<?php

namespace Cadoles\PortalBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PagetemplateSubmitType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('submit', SubmitType::class, [
                "label"         => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"          => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add('name', TextType::class, [
              'label'           => 'Nom'
            ])  

            ->add('parentfor', ChoiceType::class, [
                "label"         => 'Modèle pour les',
                "choices" => [
                    "Utilisateurs"   => 'user',
                    "Groupes"        => 'group',
                    "Application"    => 'app',
                ],                
            ])

            ->add('roworder', IntegerType::class, [
                'label'         => 'Ordre',
            ])                

            ->add('maxwidth', IntegerType::class, [
                'label'         => "Largeur maximum (0 pour largeur de l'écran)",
            ])
            

            ->add('fgpreference', ChoiceType::class, [
                "label"         => "Permettre aux utilisateurs de préserver leurs préférences d'affichage",
                "choices" => ["Oui"=> 1,"Non"=> 0],                
                "disabled"      => ($options["mode"]=="delete"?true:false),
            ])   ;   

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'Cadoles\PortalBundle\Entity\Page',
            'mode' => 'string',
            'access' => 'string'
        ]);
    }
}
