<?php

namespace Cadoles\PortalBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;

use Cadoles\PortalBundle\Entity\Alertcategory;
use Cadoles\PortalBundle\Form\AlertcategoryType;

class AlertcategoryController extends Controller
{
    private $labelroute  = 'cadoles_portal_config_alertcategory';
    private $labelentity = 'CadolesPortalBundle:Alertcategory';
    private $labeldata   = 'alertcategory';
    private $labeldatas  = 'alertcategorys';

    public function submitAction(Request $request)
    {
        // Initialisation de l'enregistrement
        $data = new Alertcategory();
        
        // Création du formulaire
        $form = $this->createForm(AlertcategoryType::class,$data,array("mode"=>"submit"));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            $em = $this->getDoctrine()->getManager();

            $idicon = $form->get('idicon')->getData();
            $icon=$this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);

            // Sauvegarde
            $em->persist($data);
            $em->flush();

            // Retour à la liste
            return $this->redirectToRoute("cadoles_portal_config_alert");
        }
        
        // Affichage du formulaire
        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'icons'             => $this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findAll(),
            'form'              => $form->createView()
        ]);
    }  

    public function updateAction($id,Request $request)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($id);
        
        // Vérifier que cet enregistrement est modifiable
                                    
        // Création du formulaire
        $form = $this->createForm(AlertcategoryType::class,$data,array(
            "mode"      =>"update",
            "idicon"    => ($data->getIcon()?$data->getIcon()->getId():null),
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $data = $form->getData();

            $idicon = $form->get('idicon')->getData();
            $icon=$this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);

            // Sauvegarde
            $em->persist($data);
            $em->flush();

            // Retour à la liste
            return $this->redirectToRoute("cadoles_portal_config_alert");
        }
        
       
        // Affichage du formulaire
        return $this->render($this->labelentity.':edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            $this->labeldata    => $data,
            'mode'              => 'update',
            'icons'             => $this->getDoctrine()->getRepository("CadolesPortalBundle:Icon")->findAll(),
            'form'              => $form->createView()
        ]);
    }

    public function deleteAction($id,Request $request)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($id);

        // Vérifier que cet enregistrement est supprimable

        // Supprimer la donnée
        $em = $this->getDoctrine()->getManager();
        $em->remove($data);
        $em->flush();
        
        return $this->redirectToRoute("cadoles_portal_config_alert");
    }

    protected function getDatas()
    {
        $em = $this->getDoctrine()->getManager();
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($id)
    {
        $em = $this->getDoctrine()->getManager();
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();
            $validator = $this->get('validator');
            $errors = $validator->validate($data);
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
