<?php
namespace Cadoles\CoreBundle\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\HttpKernel\KernelInterface;
use Doctrine\DBAL\Connection as DBALConnection;
use Doctrine\ORM\EntityManager;
use Symfony\Component\Validator\Constraints\DateTime;

use Cadoles\CoreBundle\Entity\Registration;

class TestRestCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;
    private $byexec;

    protected function configure()
    {
        $this
            ->setName('Core:TestRest')
            ->setDescription('Test REST API Ninegate')
            ->setHelp('Test REST API Ninegate')
            ->addArgument('login', InputArgument::OPTIONAL, 'uid du user à tester') 
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->container    = $this->getApplication()->getKernel()->getContainer();
        $this->em           = $this->container->get('doctrine')->getEntityManager();
        $this->output       = $output;

        // Récupérer le login à interroger
        $login = $input->getArgument('login');
        if($login=="") $login="admin";

        // Récuper la clé d'API
        $masterapikey = $this->container->getParameter('apikeyninegate');

        // Recherche des élèments de masterIdentify
        $headers = ['Accept' => 'application/json'];

        // Localisation du ninegate
        $url = "https://".$this->container->getParameter("weburl")."/".$this->container->getParameter("alias");

        // rest/user/{login}
        // Récupération des informations utilisateurs issus du masteridentity
        // key = parametre obligatoire
        // key = clé d'accès du l'api
        // only = paramétre optionnel
        // only = liste des informations désirés = user, items, bookmarks, groups, alerts, calendars
        $apiurl = $url."/rest/user/".$login;
        $this->writeln($apiurl);
        $response = \Unirest\Request::post($apiurl,$headers,["key"=>$masterapikey,"only"=>"user,items,bookmarks"]);        
        dump($response->body);

        $this->writeln('');
        return 1;

        // rest/alert/hide
        // Cache une alert à un utilisateur
        // key = parametre obligatoire
        // key = clé d'accès de l'api
        // login = parametre obligatoire
        // login = uid de l'utilisateur sur lequel on souhaite ajouter un bookmark
        // idalert = parametre obligatoire
        // idalert = id de l'alert à chacher
        $apiurl = $url."/rest/alert/hide";
        $this->writeln($apiurl);
        $response = \Unirest\Request::post($apiurl,$headers,["key"=>$masterapikey,"login"=>"admin","idalert"=>2]);        
        $idbookmark=$response->body;
        dump($response->body);




        // rest/bookmark/add
        // Ajout d'un item ninegate existant comme bookmark d'un utilisateur
        // key = parametre obligatoire
        // key = clé d'accès du l'api
        // login = parametre obligatoire
        // login = uid de l'utilisateur sur lequel on souhaite ajouter un bookmark
        // iditem = parametre obligatoire
        // iditem = id de l'item ninegate qui doit etre ajouté en tant que bookmark
        $apiurl = $url."/rest/bookmark/add";
        $this->writeln($apiurl);
        $response = \Unirest\Request::post($apiurl,$headers,["key"=>$masterapikey,"login"=>"admin","iditem"=>3]);        
        $idbookmark=$response->body;
        dump($response->body);

        // rest/bookmark/del
        // Ajout d'un item ninegate existant comme bookmark d'un utilisateur
        // key = parametre obligatoire
        // key = clé d'accès du l'api
        // idbookmark = parametre obligatoire
        // idbookmark = id du bookmark à supprimer
        $apiurl = $url."/rest/bookmark/del";
        $this->writeln($apiurl);
        $response = \Unirest\Request::post($apiurl,$headers,["key"=>$masterapikey,"idbookmark"=>$idbookmark]);        
        $idbookmark=$response->body;
        dump($response->body);

        $this->writeln('');
        return 1;
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
    }
    private function writeln($string) { 
        $this->output->writeln($string);
    }     
}
